/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.mapper.ApplyMapper;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ApplyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private static final String EQUIPMENT_APPLY_BILL_CODE = "EQUIPMENT_APPLY";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<ApplyVO> saveOrUpdate(ApplyVO applyVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ApplyEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)applyVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_APPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                applyVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (applyVo.getId() != null && applyVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ApplyEntity::getBillCode, (Object)applyVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)applyVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ApplyEntity::getBillCode, (Object)applyVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (ApplyEntity)((Object)BeanMapper.map((Object)applyVo, ApplyEntity.class));
        entity.setDr(0);
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ApplyVO.class));
    }

    @Override
    public ApplyVO queryDetail(Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)super.selectById((Serializable)id));
        ApplyVO applyVo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return applyVo;
    }

    @Override
    public void deleteApply(List<ApplyVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }
}

