/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractClauseEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseContractFeeEntity;
import com.ejianc.business.equipment.bean.PurchaseRecordEntity;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractClauseService;
import com.ejianc.business.equipment.service.IPurchaseContractFeeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseRecordService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseChange")
public class PurchaseChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IPurchaseContractClauseService purchaseContractClauseService;
    @Autowired
    private IPurchaseContractFeeService purchaseContractFeeService;
    @Autowired
    private IPurchaseRecordService purchaseRecordService;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        PurchaseChangeEntity changeEntity = (PurchaseChangeEntity)((Object)this.purchaseChangeService.selectById(billId));
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(changeEntity.getContractId()));
        PurchaseRecordEntity recordEntity = (PurchaseRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), PurchaseRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchasedetail())) {
            recordEntity.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchasefee())) {
            recordEntity.getPurchasefee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchaseclause())) {
            recordEntity.getPurchaseclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        this.purchaseRecordService.saveOrUpdate((Object)recordEntity, false);
        changeEntity.setChangeTime(new Date());
        this.purchaseChangeService.saveOrUpdate((Object)changeEntity, false);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setContractStatus(changeEntity.getChangeStatus());
        this.purchaseContractClauseService.deleteByContractId(changeEntity.getContractId());
        this.purchaseContractFeeService.deleteByContractId(changeEntity.getContractId());
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchasedetail())) {
            changeEntity.getPurchasedetail().forEach(vo -> vo.setId(vo.getContractDetailId()));
            contractEntity.setPurchasedetail(BeanMapper.mapList(changeEntity.getPurchasedetail(), PurchaseContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchasefee())) {
            changeEntity.getPurchasefee().forEach(vo -> vo.setId(null));
            contractEntity.setPurchasefee(BeanMapper.mapList(changeEntity.getPurchasefee(), PurchaseContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchaseclause())) {
            changeEntity.getPurchaseclause().forEach(vo -> vo.setId(null));
            contractEntity.setPurchaseclause(BeanMapper.mapList(changeEntity.getPurchaseclause(), PurchaseContractClauseEntity.class));
        }
        boolean flag = this.purchaseContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }
}

