/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rentContract"})
public class RentContractController {
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentContractVO> saveOrUpdate(@RequestBody RentContractVO rentContractVo) {
        return this.rentContractService.saveOrUpdate(rentContractVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentContractVO> queryDetail(@RequestParam Long id) {
        RentContractVO rentContractVo = this.rentContractService.queryDetail(id);
        return CommonResponse.success((Object)rentContractVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentContractVO> vos) {
        this.rentContractService.deleteRentContract(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.rentContractService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/rentContractRef"})
    public CommonResponse<IPage<RentContractVO>> projectListRefe(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        CommonResponse orgListResp;
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("orgId")) {
            orgId = Long.valueOf(conditionMap.get("orgId").toString());
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue(), 0L);
            return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01", (Object)pageData);
        }
        List orgList = (List)orgListResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            orgList.stream().forEach(orgVO -> {
                if (5 == orgVO.getOrgType()) {
                    departmentIds.add(orgVO.getId());
                } else {
                    commonOrgIds.add(orgVO.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)commonOrgIds)) {
                    queryParam.getParams().put("orgId", new Parameter("in", (Object)commonOrgIds));
                } else if (CollectionUtils.isNotEmpty((Collection)departmentIds)) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter("eq", departmentIds.get(0)));
                }
            });
        }
        IPage pageData = this.rentContractService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class));
        return CommonResponse.success((String)"\u9879\u76ee\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }
}

