/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordMapper;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentUseRecordService")
public class RentUseRecordServiceImpl
extends BaseServiceImpl<RentUseRecordMapper, RentUseRecordEntity>
implements IRentUseRecordService {
    private static final String RENT_USE_BILL_CODE = "EQUIPMENT_RENT_USE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;

    @Override
    public CommonResponse<RentUseRecordVO> saveOrUpdate(RentUseRecordVO rentUseRecordVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentUseRecordEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)rentUseRecordVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_USE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentUseRecordVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (rentUseRecordVo.getId() != null && rentUseRecordVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentUseRecordEntity::getBillCode, (Object)rentUseRecordVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentUseRecordVo.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentUseRecordEntity::getBillCode, (Object)rentUseRecordVo.getBillCode());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (RentUseRecordEntity)((Object)BeanMapper.map((Object)rentUseRecordVo, RentUseRecordEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentUseRecordVO.class));
    }

    @Override
    public RentUseRecordVO queryDetail(Long id) {
        RentUseRecordEntity entity = (RentUseRecordEntity)((Object)super.selectById((Serializable)id));
        RentUseRecordVO rentUseRecordVo = (RentUseRecordVO)BeanMapper.map((Object)((Object)entity), RentUseRecordVO.class);
        return rentUseRecordVo;
    }

    @Override
    public void deleteRentUseRecord(List<RentUseRecordVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }
}

