package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.ApplyDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.service.IApplyDetailService;
import com.ejianc.business.equipment.vo.ApplyDetailVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备使用申请明细 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@RestController
@RequestMapping("applyDetail")
public class ApplyDetailController {
    @Autowired
    private IApplyDetailService applyDetailService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 设备使用申请列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @GetMapping("/applyDetailRef")
    public CommonResponse<IPage<ApplyDetailVO>> applyDetailRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                 @RequestParam(defaultValue = "10") Integer pageSize,
                                                                 @RequestParam(value = "condition", required = false) String relyCondition,
                                                                 @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            queryParam.getParams().put("applyId", new Parameter(QueryParam.EQ, categoryId));

        }
        IPage<ApplyDetailEntity> pageData = applyDetailService.queryPage(queryParam,false);
        IPage<ApplyDetailVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), ApplyDetailVO.class));
        return CommonResponse.success("设备使用申请详情查询成功！", result);
    }
}
