package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备合同表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@RestController
@RequestMapping("rentContract")
public class RentContractController {
    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 新增或者修改
     *
     * @param rentContractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentContractVO> saveOrUpdate(@RequestBody RentContractVO rentContractVo) {
        return rentContractService.saveOrUpdate(rentContractVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractVO> queryDetail(@RequestParam Long id) {
        RentContractVO rentContractVo = rentContractService.queryDetail(id);
        return CommonResponse.success(rentContractVo);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentContractVO> vos) {
        rentContractService.deleteRentContract(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        IPage<RentContractEntity> pageData= rentContractService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/rentContractRef")
    public CommonResponse<IPage<RentContractVO>> projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                    @RequestParam(defaultValue = "10") Integer pageSize,
                                                                    @RequestParam(value = "condition", required = false) String condition,
                                                                    @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");

        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            IPage<RentContractVO> pageData = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageNumber, pageSize, 0);
            return CommonResponse.success("查询数表参照失败，项目组织信息查询失败！", pageData);
        }
        List<OrgVO> orgList = orgListResp.getData();

        if(CollectionUtils.isNotEmpty(orgList)) {
            orgList.stream().forEach(orgVO -> {
                if(5 == orgVO.getOrgType()) {
                    //项目部
                    departmentIds.add(orgVO.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(orgVO.getId());
                }
                if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                    queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ, departmentIds.get(0)));
                }
            });
        }

        IPage<RentContractEntity> pageData = rentContractService.queryPage(queryParam,false);
        IPage<RentContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), RentContractVO.class));
        return CommonResponse.success("项目参照查询成功！", result);
    }
}
