package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.ApplyDetailEntity;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.mapper.ApplyMapper;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.vo.ApplyDetailVO;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备使用申请表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@Service("ApplyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService {
    private static final String EQUIPMENT_APPLY_BILL_CODE = "EQUIPMENT_APPLY";

//    @Autowired
//    private IDefdocDetailService defdocDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<ApplyVO> saveOrUpdate(ApplyVO applyVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ApplyEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(applyVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_APPLY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                applyVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(applyVo.getId() != null && applyVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ApplyEntity> lambda = Wrappers.<ApplyEntity>lambdaQuery();
            lambda.eq(ApplyEntity::getBillCode, applyVo.getBillCode());
            lambda.eq(ApplyEntity::getTenantId, tenantId);
            lambda.ne(ApplyEntity::getId, applyVo.getId());
            List<ApplyEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<ApplyEntity> lambda = Wrappers.<ApplyEntity>lambdaQuery();
            lambda.eq(ApplyEntity::getTenantId, tenantId);
            lambda.eq(ApplyEntity::getBillCode, applyVo.getBillCode());
            List<ApplyEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(applyVo, ApplyEntity.class);
        entity.setDr(0);
        //汇总设备明细名称
        List<ApplyDetailEntity> applyDetail = entity.getApplyDetail();
        String equipmentName = "";
        if(applyDetail != null && applyDetail.size() > 0){
            for(ApplyDetailEntity applyDetailEntity : applyDetail){
                equipmentName = equipmentName + applyDetailEntity.getName() + ",";
            }
            String substring = equipmentName.substring(0, equipmentName.length() - 1);
            entity.setEquipmentName(substring);
        }

        super.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity, ApplyVO.class));
    }

    @Override
    public ApplyVO queryDetail(Long id) {
        ApplyEntity entity = super.selectById(id);
        ApplyVO applyVo = BeanMapper.map(entity, ApplyVO.class);
        return applyVo;
    }

    @Override
    public void deleteApply(List<ApplyVO> vos) {
        super.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public List<ApplyVO> applyTree() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ApplyEntity> lambda = Wrappers.<ApplyEntity>lambdaQuery();
        lambda.eq(ApplyEntity::getTenantId, tenantId);
        List<ApplyEntity> list = super.list(lambda);
        List<ApplyVO> applyVOList = BeanMapper.mapList(list, ApplyVO.class);
        for (ApplyVO applyVo : applyVOList){
            applyVo.setName(applyVo.getBillCode() + applyVo.getPlanDate());
        }
        return applyVOList;
    }
    @Override
    public List<ApplyVO> queryListTree(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ApplyEntity> lambda = Wrappers.<ApplyEntity>lambdaQuery();
        lambda.eq(ApplyEntity::getTenantId, tenantId);
        List<ApplyEntity> dataList = super.list(lambda);
        if(dataList != null && dataList.size() > 0) {
            return BeanMapper.mapList(dataList, ApplyVO.class);
        }
        return null;
    }
}
