package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseRecordEntity;
import com.ejianc.business.equipment.mapper.PurchaseRecordMapper;
import com.ejianc.business.equipment.service.IPurchaseRecordService;
import com.ejianc.business.equipment.vo.PurchaseRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service("PurchaseRecordService")
public class PurchaseRecordServiceImpl extends BaseServiceImpl<PurchaseRecordMapper, PurchaseRecordEntity> implements IPurchaseRecordService {

    @Override
    public PurchaseRecordVO queryDetail(Long id) {
        LambdaQueryWrapper<PurchaseRecordEntity> lambda = Wrappers.<PurchaseRecordEntity>lambdaQuery();
        lambda.eq(PurchaseRecordEntity::getChangeId, id);
        PurchaseRecordEntity entity = super.getOne(lambda);
        if(null!=entity&&null!=entity.getId()){
            PurchaseRecordEntity aggVO = super.getById(entity.getId());
            PurchaseRecordVO purchaseRecordVo = BeanMapper.map(aggVO, PurchaseRecordVO.class);
            return purchaseRecordVo;
        }else{
            return new PurchaseRecordVO();
        }
    }
}