package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementDetailVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseSettlementService")
public class PurchaseSettlementServiceImpl extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {

    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";

    @Autowired
    private IPurchaseContractService purchaseContractService;


    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
//变更合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId,purchaseSettlementVo.getContractId());
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的结算单!");
        }
        BigDecimal sumSettlementTaxMny = purchaseSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumSettlementTaxMny();
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal contractTaxMny = purchaseSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getContractTaxMny();
        if(contractTaxMny.compareTo(sumSettlementTaxMny.add(settlementTaxMny))<0){
            throw new BusinessException("该合同结算金额已经超过合同金额!");
        }
        BigDecimal sumPayMny = purchaseSettlementVo.getSumPayMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumPayMny();//预付款金额
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal sumOffsetMny = purchaseSettlementVo.getSumOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumOffsetMny();//累计冲抵金额
        if(offsetMny.compareTo(sumPayMny.subtract(sumOffsetMny))>0){
            throw new BusinessException("该合同冲抵金额已超出预付款金额!");
        }
        if(StringUtils.isEmpty(purchaseSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity = BeanMapper.map(purchaseSettlementVo, PurchaseSettlementEntity.class);
        super.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity, PurchaseSettlementVO.class));
    }
    
    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        PurchaseSettlementEntity entity = super.selectById(id);
        PurchaseSettlementVO purchaseSettlementVo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        return purchaseSettlementVo;
    }
    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseSettlementVO purchaseSettlementVO = BeanMapper.map(entity, PurchaseSettlementVO.class);
        //新增逻辑处理
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        return purchaseSettlementVO;
    }
    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:entity.getSumSettlementTaxMny();//累计结算金额
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSumSettlementTaxMny(sumSettlementTaxMny);
        if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)>0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
            vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        LambdaQueryWrapper<PurchaseSettlementEntity> lambda = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId,id);
        lambda.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> entities = super.list(lambda);
        if(true){
            vo.setSettlementRecord(BeanMapper.mapList(entities, PurchaseSettlementVO.class));
        }
        return vo;
    }
}
