package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.mapper.RentChangeMapper;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.vo.RentChangeRecordVO;
import com.ejianc.business.equipment.vo.RentChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@Service("RentChangeService")
public class RentChangeServiceImpl extends BaseServiceImpl<RentChangeMapper, RentChangeEntity> implements IRentChangeService {
    private static final String RENT_CHANGE_BILL_CODE = "EQUIPMENT_RENT_CHANGE";

    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<RentChangeVO> saveOrUpdate(RentChangeVO rentChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentChangeEntity entity = null;
        List<RentContractEntity> entitiesc = null;
        List<RentChangeEntity> entities = null;
        RentContractEntity pcentity = rentContractService.selectById(rentChangeVo.getContractId());
        if(StringUtils.isEmpty(rentChangeVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CHANGE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentChangeVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentChangeVo.getId() != null && rentChangeVo.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getBillCode, rentChangeVo.getBillCode());
            lambda.eq(RentChangeEntity::getTenantId, tenantId);
            lambda.ne(RentChangeEntity::getContractId,rentChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rentChangeVo.getContractId()));
            entitiesc = rentContractService.queryList(queryParam,false);

            pcentity.setId(rentChangeVo.getContractId());

            if(CollectionUtils.isNotEmpty(rentChangeVo.getRentdetail())){
                rentChangeVo.getRentdetail().forEach(vo -> {
                    //变更类型1-增补，2-变更，3-中止
                    if("add".equals(vo.getRowState())){
                        vo.setContractDetailId(vo.getId());
                        vo.setContractId(rentChangeVo.getContractId());
                        vo.setChangeType(1);
                    }else if("edit".equals(vo.getRowState())){
                        vo.setChangeType(2);
                    }else{
                        vo.setChangeType(3);
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(rentChangeVo.getRentfee())){
                rentChangeVo.getRentfee().forEach(vo -> {
                    if("add".equals(vo.getRowState())){
                        vo.setContractId(rentChangeVo.getContractId());
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(rentChangeVo.getRentclause())){
                rentChangeVo.getRentclause().forEach(vo -> {
                    if("add".equals(vo.getRowState())){
                        vo.setContractId(rentChangeVo.getContractId());
                    }
                });
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getTenantId, tenantId);
            lambda.eq(RentChangeEntity::getBillCode, rentChangeVo.getBillCode());
            lambda.ne(RentChangeEntity::getContractId,rentChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,rentChangeVo.getContractId()));
            entitiesc = rentContractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(rentChangeVo.getContractId());
            pcentity.setChangeVersion(rentChangeVo.getChangeVersion()+1);
            rentChangeVo.setChangeVersion(rentChangeVo.getChangeVersion()+1);
            rentChangeVo.setMakeTime(new Date());
            if(CollectionUtils.isNotEmpty(rentChangeVo.getRentdetail())){
                rentChangeVo.getRentdetail().forEach(vo -> {
                    //变更类型1-增补，2-变更，3-中止
                    if("add".equals(vo.getRowState())){
                        vo.setContractDetailId(vo.getId());
                        vo.setContractId(rentChangeVo.getContractId());
                        vo.setChangeType(1);
                    }else if("edit".equals(vo.getRowState())){
                        vo.setChangeType(2);
                    }else{
                        vo.setChangeType(3);
                    }
                });
            }

        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(rentChangeVo, RentChangeEntity.class);
//        entity.setTenantId(tenantId);
        super.saveOrUpdate(entity,false);
        //会写合同表
        pcentity.setChangeStatus(2);
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        rentContractService.update(pcentity, new QueryWrapper<RentContractEntity>().eq("id",pcentity.getId()),false);
        return CommonResponse.success(BeanMapper.map(entity, RentChangeVO.class));
    }

    @Override
    public RentChangeVO queryDetail(Long id) {
        RentChangeEntity entity = super.selectById(id);
        RentChangeVO rentChangeVo = BeanMapper.map(entity, RentChangeVO.class);
        return rentChangeVo;
    }

    @Override
    public RentChangeVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentChangeVO rentChangeVo = BeanMapper.map(entity, RentChangeVO.class);
        //新增逻辑处理
        rentChangeVo.setContractId(rentChangeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentChangeVo.setId(null);
        rentChangeVo.setBillState(null);
        rentChangeVo.setCreateUserCode(null);
        rentChangeVo.setCreateTime(null);
        rentChangeVo.setUpdateUserCode(null);
        rentChangeVo.setUpdateTime(null);
        rentChangeVo.setChangeDate(new Date());
        rentChangeVo.setBeforeContractName(entity.getContractName());
        rentChangeVo.setBeforeChangeMny(entity.getContractMny());
        rentChangeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        rentChangeVo.setBeforeContractName(rentChangeVo.getContractName());
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentdetail())){
            rentChangeVo.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentfee())){
            rentChangeVo.getRentfee().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        if(CollectionUtils.isNotEmpty(rentChangeVo.getRentclause())){
            rentChangeVo.getRentclause().forEach(vo -> {
                vo.setContractId(rentChangeVo.getContractId());
                vo.setRowState("add");
            });
        }
        return rentChangeVo;
    }

    @Override
    public RentChangeRecordVO queryChangeRecord(Long id) {
        RentChangeRecordVO vo = new RentChangeRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMoney()==null?BigDecimal.ZERO:entity.getBaseTaxMoney();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractTaxMny(contractTaxMny);
//        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
//        vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney)));
        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<RentChangeEntity> lambda = Wrappers.<RentChangeEntity>lambdaQuery();
            lambda.eq(RentChangeEntity::getContractId,id);
            lambda.in(RentChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            List<RentChangeEntity> entities = super.list(lambda);
//            entities.forEach(changevo -> {
//                changevo.setBillCode("");
//                changevo.set
//              }
//            );
            vo.setChangeRecord(BeanMapper.mapList(entities, RentChangeVO.class));
        }
        return vo;
    }

    @Override
    public void deleteRentChange(List<RentChangeVO> vos) {
        super.removeByIds(vos.stream().map(RentChangeVO::getId).collect(Collectors.toList()),false);
    }
}
