package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.mapper.RentSettlementMapper;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Service("RentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "EQUIPMENT_RENT_SETTLEMENT";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(rentSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentSettlementVo.getId() != null && rentSettlementVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
            lambda.eq(RentSettlementEntity::getBillCode, rentSettlementVo.getBillCode());
            lambda.eq(RentSettlementEntity::getTenantId, tenantId);
            lambda.ne(RentSettlementEntity::getId, rentSettlementVo.getId());
            List<RentSettlementEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
            lambda.eq(RentSettlementEntity::getTenantId, tenantId);
            lambda.eq(RentSettlementEntity::getBillCode, rentSettlementVo.getBillCode());
            List<RentSettlementEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(rentSettlementVo, RentSettlementEntity.class);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentSettlementVO.class));
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = super.selectById(id);
        RentSettlementVO rentSettlementVo = BeanMapper.map(entity, RentSettlementVO.class);
        return rentSettlementVo;
    }

    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        super.removeByIds(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()),false);
    }
}
