package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_equipment_rent_settlement_detail")
public class RentSettlementDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 设备档案主键
     */
    @TableField("equipment_id")
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 合同使用记录主键
     */
    @TableField("use_id")
    private Long useId;

    /**
     * 合同使用记录子表主键
     */
    @TableField("use_detail_id")
    private Long useDetailId;

    /**
     * 使用记录编码
     */
    @TableField("use_code")
    private Long useCode;

    /**
     * 来源类型,0-设备档案,1-设备使用记录,2-设备租赁合同
     */
    @TableField("source")
    private Integer source;

    /**
     * 设备编码
     */
    @TableField("code")
    private String code;

    /**
     * 设备名称
     */
    @TableField("name")
    private String name;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计量单位名称
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    @TableField("settlement_mny")
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 起租日期
     */
    @TableField("start_date")
    private Date startDate;

    /**
     * 停租日期
     */
    @TableField("end_date")
    private Date endDate;

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getUseDetailId() {
        return useDetailId;
    }

    public void setUseDetailId(Long useDetailId) {
        this.useDetailId = useDetailId;
    }
    public Long getUseCode() {
        return useCode;
    }

    public void setUseCode(Long useCode) {
        this.useCode = useCode;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }


}
