package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.service.impl.RentChangeBpmServiceImpl;
import com.ejianc.business.equipment.vo.ApplyDetailVO;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.business.equipment.vo.RentUseRecordDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 设备使用申请表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@RestController
@RequestMapping("apply")
public class ApplyController {
    @Autowired
    private IApplyService applyService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 新增或者修改
     *
     * @param applyVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVo) {
        return applyService.saveOrUpdate(applyVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(@RequestParam Long id) {
        ApplyVO applyVo = applyService.queryDetail(id);
        return CommonResponse.success(applyVo);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        applyService.deleteApply(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        IPage<ApplyEntity> pageData= applyService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ApplyVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 设备使用申请树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/applyRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> applyRefTree(@RequestParam(required = false) String searchText) {
        List<ApplyVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = applyService.queryListTree(params);
            if (dataList != null && dataList.size() > 0){
                for (ApplyVO applyVO : dataList){

                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String plandate = formatter.format(applyVO.getPlanDate());
                    applyVO.setName(applyVO.getBillCode()+"+"+plandate);
                }
            }
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }
    /**
     * 设备使用申请编号+日期属性结构
     */
    @RequestMapping(value = "/applyTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ApplyVO>> applyTree() {
        List<ApplyVO> list = applyService.applyTree();
        return CommonResponse.success(list);
    }
}
