package com.ejianc.business.equipment.controller;


import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.vo.PurchaseChangeRecordVO;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 设备合同变更表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@RestController
@RequestMapping("purchaseChange")
public class PurchaseChangeController {

    @Autowired
    private IPurchaseChangeService purchaseChangeService;

    /**
     * 新增或者修改
     *
     * @param purchaseChangeVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(@RequestBody PurchaseChangeVO purchaseChangeVo) {
        return purchaseChangeService.saveOrUpdate(purchaseChangeVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> queryDetail(@RequestParam Long id) {
        PurchaseChangeVO purchaseChangeVo = purchaseChangeService.queryDetail(id);
        return CommonResponse.success(purchaseChangeVo);
    }

    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> queryDetails(@RequestParam Long id) {
        PurchaseChangeVO purchaseChangeVo = purchaseChangeService.queryDetails(id);
        return CommonResponse.success(purchaseChangeVo);
    }

    /**
     * 根据合同主键ID查询变更记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseChangeRecordVO> queryDetailRecord(@RequestParam Long id) {
        PurchaseChangeRecordVO changeRecordVO = purchaseChangeService.queryChangeRecord(id);
        return CommonResponse.success(changeRecordVO);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseChangeVO> vos) {
        purchaseChangeService.deletePurchaseChange(vos);
        return CommonResponse.success("删除成功");
    }

}
