package com.ejianc.business.equipment.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("purchaseContract")
public class PurchaseContractController {

    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IOrgApi orgApi;

//    @Autowired
//    private ICommonBusinessService purchaseChange;


    /**
     * 新增或者修改
     *
     * @param purchaseContractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO purchaseContractVo) {
        return purchaseContractService.saveOrUpdate(purchaseContractVo);
    }

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(@RequestParam Long id) {
//        purchaseChange.afterApprovalProcessor(326410868312244268L,1);
        PurchaseContractVO purchaseContractVo = purchaseContractService.queryDetail(id);
        return CommonResponse.success(purchaseContractVo);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        purchaseContractService.deletePurchaseContract(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            return CommonResponse.success("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> allOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        allOrgIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        childIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        allOrgIds.remove(orgId);
        allOrgIds.addAll(childIds);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, allOrgIds));
        c1.getComplexParams().add(c2);

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        billstate.add(1);
        billstate.add(3);
        c3.getParams().put("purchase_type",new Parameter(QueryParam.EQ,"2"));
        c3.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        c3.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        IPage<PurchaseContractEntity> pageData= purchaseContractService.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = purchaseContractService.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("PurchaseCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/purchaseContractRef")
    public CommonResponse<IPage<PurchaseContractVO>> projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "condition", required = false) String condition,
                                                           @RequestParam(value = "searchText", required = false) String searchText) {

        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");

        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);

            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            IPage<PurchaseContractVO> pageData = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageNumber, pageSize, 0);
            return CommonResponse.success("查询数表参照失败，项目组织信息查询失败！", pageData);
        }
        List<OrgVO> orgList = orgListResp.getData();
        if(CollectionUtils.isNotEmpty(orgList)) {
            orgList.stream().forEach(orgVO -> {
                commonOrgIds.add(orgVO.getId());
            });
        }
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(1);
        billstate.add(3);
        queryParam.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        IPage<PurchaseContractEntity> pageData = purchaseContractService.queryPage(queryParam,false);
        IPage<PurchaseContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

    /**
     * 合同状态修改
     *
     * @param purchaseContractVO
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody PurchaseContractVO purchaseContractVO) {
        LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PurchaseContractEntity::getId,purchaseContractVO.getId());
        updateWrapper.set(PurchaseContractEntity::getContractStatus, purchaseContractVO.getContractStatus());
        purchaseContractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }
}
