package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同结算表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@RestController
@RequestMapping("purchaseSettlement")
public class PurchaseSettlementController {

    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;

    @Autowired
    private IOrgApi orgApi;
    
    /**
     * 新增或者修改
     *
     * @param purchaseSettlementVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(@RequestBody PurchaseSettlementVO purchaseSettlementVo) {
        return purchaseSettlementService.saveOrUpdate(purchaseSettlementVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetail(@RequestParam Long id) {
        PurchaseSettlementVO purchaseSettlementVo = purchaseSettlementService.queryDetail(id);
        return CommonResponse.success(purchaseSettlementVo);
    }

    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetails(@RequestParam Long id) {
        PurchaseSettlementVO purchaseSettlementVO = purchaseSettlementService.queryDetails(id);
        return CommonResponse.success(purchaseSettlementVO);
    }

    /**
     * 根据合同主键ID查询结算记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseSettlementRecordVO> queryDetailRecord(@RequestParam Long id) {
        PurchaseSettlementRecordVO purchaseSettlementRecordVO = purchaseSettlementService.querySettlementRecord(id);
        return CommonResponse.success(purchaseSettlementRecordVO);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementVO> vos) {
        purchaseSettlementService.deletePurchaseSettlement(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("SettlementName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<PurchaseSettlementEntity> pageData= purchaseSettlementService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PurchaseSettlementVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
}
