package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 租赁设备使用记录 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@RestController
@RequestMapping("rentUseRecord")
public class RentUseRecordController {
    @Autowired
    private IRentUseRecordService rentUseRecordService;

    /**
     * 新增或者修改
     *
     * @param rentUseRecordVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> saveOrUpdate(@RequestBody RentUseRecordVO rentUseRecordVo) {
        return rentUseRecordService.saveOrUpdate(rentUseRecordVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetail(@RequestParam Long id) {
        RentUseRecordVO rentUseRecordVo = rentUseRecordService.queryDetail(id);
        return CommonResponse.success(rentUseRecordVo);
    }


    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentUseRecordVO> vos) {
        rentUseRecordService.deleteRentUseRecord(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("SettlementName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        IPage<RentUseRecordEntity> pageData= rentUseRecordService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
}
