package com.ejianc.business.equipment.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.finance.pub.vo.PubContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/equipment/")
public class EquipmentContractApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IPurchaseContractService contractService;
	
	@RequestMapping(value = "getContract", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> getContract(QueryParam param) {
		try {
			param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
			IPage<PurchaseContractEntity> pageData= contractService.queryPage(param,false);

			List<PurchaseContractEntity> contractEntityList = pageData.getRecords();
			List<PubContractVO> contractVOList = new ArrayList<>();
			for(PurchaseContractEntity entity : contractEntityList){
				PubContractVO vo = new PubContractVO();
				vo.setId(entity.getId());
				vo.setBillCode(entity.getBillCode());
				vo.setContractName(entity.getContractName());
				vo.setContractMny(entity.getContractTaxMny());
				vo.setContractType(2);
				vo.setPurchaseType(entity.getPurchaseType());
				vo.setProjectId(entity.getProjectId());
				vo.setOrgId(entity.getOrgId());
				vo.setReceiveUnitId(entity.getSupplierId());
				vo.setSumInvoiceMny(entity.getSumInvoiceTaxMny());
				vo.setSumPayMny(entity.getSumPayMny());
				vo.setSumSettleMny(entity.getSumSettlementTaxMny());
				vo.setPayScale(entity.getPayScale());
				contractVOList.add(vo);
			}

			JSONObject page = new JSONObject();
			page.put("records", contractVOList);
			page.put("total", pageData.getTotal());
			page.put("current", pageData.getCurrent());
			page.put("size", pageData.getSize());
			page.put("pages", pageData.getPages());

			return CommonResponse.success("查询列表数据成功！", page);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

}
