package com.ejianc.business.equipment.service.impl;

import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * <p>
 * 设备合同结算单审批操作后
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("purchaseSettlement")
public class PurchaseSettlementBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        PurchaseSettlementEntity settlementEntity= purchaseSettlementService.selectById(billId);
        BigDecimal offsetMny = settlementEntity.getOffsetMny()==null?BigDecimal.ZERO:settlementEntity.getOffsetMny();//本次冲抵金额
        BigDecimal settlementMny = settlementEntity.getSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementMny();//本期结算金额(不含税)
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getSettlementTaxMny();//本期结算金额(含税)

        //1，先查出合同
        PurchaseContractEntity contractEntity = purchaseContractService.selectById(settlementEntity.getContractId());
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny()==null?BigDecimal.ZERO:contractEntity.getSumOffsetMny();//累计冲抵金额
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementMny();//累计结算金额(不含税)
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumSettlementTaxMny();//累计结算金额

        BigDecimal contractTaxMny = settlementEntity.getContractTaxMny()==null?BigDecimal.ZERO:settlementEntity.getContractTaxMny();
        if(contractTaxMny.compareTo(sumSettlementTaxMny.add(settlementTaxMny))<0){
            return CommonResponse.error("审批回写异常!该合同结算金额已经超过合同金额!");
        }
        BigDecimal sumPayMny = settlementEntity.getSumPayMny()==null?BigDecimal.ZERO:settlementEntity.getSumPayMny();//预付款金额
        if(offsetMny.compareTo(sumPayMny.subtract(sumOffsetMny))>0){
            return CommonResponse.error("审批回写异常!该合同冲抵金额已超出预付款金额!");
        }

        contractEntity.setSumOffsetMny(sumOffsetMny.add(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.add(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.add(settlementTaxMny));
        logger.info("业务逻辑完成--"+contractEntity.getSumOffsetMny()+"    --"+contractEntity.getSumSettlementTaxMny());

        Boolean flag = purchaseContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        if(flag){
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }

}
