package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordDetailMapper;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.vo.RentUseRecordDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 设备明细 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@Service("RentUseRecordDetailService")
public class RentUseRecordDetailServiceImpl extends BaseServiceImpl<RentUseRecordDetailMapper, RentUseRecordDetailEntity> implements IRentUseRecordDetailService {

    @Override
    public List<RentUseRecordDetailVO> useDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<RentUseRecordDetailEntity> lambda = Wrappers.<RentUseRecordDetailEntity>lambdaQuery();
        lambda.eq(RentUseRecordDetailEntity::getTenantId, tenantId);
        lambda.ne(RentUseRecordDetailEntity::getUseId, id);
        List<RentUseRecordDetailEntity> entities = super.list(lambda);
        List<RentUseRecordDetailVO> rentUseRecordVo = BeanMapper.mapList(entities,RentUseRecordDetailVO.class);
        return rentUseRecordVo;
    }
}
