package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordMapper;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 租赁设备使用记录 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@Service("RentUseRecordService")
public class RentUseRecordServiceImpl extends BaseServiceImpl<RentUseRecordMapper, RentUseRecordEntity> implements IRentUseRecordService {
    private static final String RENT_USE_BILL_CODE = "EQUIPMENT_RENT_USE";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;
    @Override
    public CommonResponse<RentUseRecordVO> saveOrUpdate(RentUseRecordVO rentUseRecordVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
    RentUseRecordEntity entity = null;
    String operateType = null;
        if(StringUtils.isEmpty(rentUseRecordVo.getBillCode())){
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_USE_BILL_CODE,tenantId);
        if(billCode.isSuccess()) {
            rentUseRecordVo.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }
        if(rentUseRecordVo.getId() != null && rentUseRecordVo.getId() > 0) {
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<RentUseRecordEntity> lambda = Wrappers.<RentUseRecordEntity>lambdaQuery();
        lambda.eq(RentUseRecordEntity::getBillCode, rentUseRecordVo.getBillCode());
        lambda.eq(RentUseRecordEntity::getTenantId, tenantId);
        lambda.ne(RentUseRecordEntity::getId, rentUseRecordVo.getId());
        List<RentUseRecordEntity> entities = super.list(lambda);
        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }else{
        //校验合同编号是否重复
        LambdaQueryWrapper<RentUseRecordEntity> lambda = Wrappers.<RentUseRecordEntity>lambdaQuery();
        lambda.eq(RentUseRecordEntity::getTenantId, tenantId);
        lambda.eq(RentUseRecordEntity::getBillCode, rentUseRecordVo.getBillCode());
        List<RentUseRecordEntity> entities = super.list(lambda);
        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }
    entity = BeanMapper.map(rentUseRecordVo, RentUseRecordEntity.class);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentUseRecordVO .class));
}

    @Override
    public RentUseRecordVO queryDetail(Long id) {
        RentUseRecordEntity entity = super.selectById(id);
        RentUseRecordVO rentUseRecordVo = BeanMapper.map(entity, RentUseRecordVO.class);
        return rentUseRecordVo;
    }

    @Override
    public void deleteRentUseRecord(List<RentUseRecordVO> vos) {
        super.removeByIds(vos.stream().map(RentUseRecordVO::getId).collect(Collectors.toList()),false);
    }


}
