/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseSettlementService")
public class PurchaseSettlementServiceImpl
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        BigDecimal sumOffsetMny;
        BigDecimal contractTaxMny;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
        }
        lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.ge(PurchaseSettlementEntity::getSettlementDate, (Object)purchaseSettlementVo.getSettlementDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal sumSettlementTaxMny = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal bigDecimal = contractTaxMny = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        if (contractTaxMny.compareTo(sumSettlementTaxMny.add(settlementTaxMny)) < 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u7ed3\u7b97\u91d1\u989d\u5df2\u7ecf\u8d85\u8fc7\u5408\u540c\u91d1\u989d!");
        }
        BigDecimal sumPayMny = purchaseSettlementVo.getSumPayMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumPayMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getOffsetMny();
        BigDecimal bigDecimal2 = sumOffsetMny = purchaseSettlementVo.getSumOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumOffsetMny();
        if (offsetMny.compareTo(sumPayMny.subtract(sumOffsetMny)) > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        if (StringUtils.isEmpty((CharSequence)purchaseSettlementVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)purchaseSettlementVo, PurchaseSettlementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class));
    }

    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)super.selectById((Serializable)id));
        PurchaseSettlementVO purchaseSettlementVo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        return purchaseSettlementVo;
    }

    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        BigDecimal cc;
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        PurchaseSettlementVO purchaseSettlementVO = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);
        BigDecimal c = purchaseSettlementVO.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getContractTaxMny();
        BigDecimal bigDecimal = cc = purchaseSettlementVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        return purchaseSettlementVO;
    }

    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettlementTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSumSettlementTaxMny(sumSettlementTaxMny);
        if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) > 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
            vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
        } else {
            vo.setSumScale(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId, (Object)id);
        lambda.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            vo.setSettlementRecord(BeanMapper.mapList((Iterable)entities, PurchaseSettlementVO.class));
        }
        return vo;
    }
}

