package com.ejianc.business.equipment.controller;


import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.vo.RentChangeRecordVO;
import com.ejianc.business.equipment.vo.RentChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 设备合同表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@RestController
@RequestMapping("rentChange")
public class RentChangeController {
    @Autowired
    private IRentChangeService rentChangeService;

    /**
     * 新增或者修改
     *
     * @param rentChangeVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentChangeVO> saveOrUpdate(@RequestBody RentChangeVO rentChangeVo) {
        return rentChangeService.saveOrUpdate(rentChangeVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentChangeVO> queryDetail(@RequestParam Long id) {
        RentChangeVO rentChangeVo = rentChangeService.queryDetail(id);
        return CommonResponse.success(rentChangeVo);
    }

    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentChangeVO> queryDetails(@RequestParam Long id) {
        RentChangeVO rentChangeVo = rentChangeService.queryDetails(id);
        return CommonResponse.success(rentChangeVo);
    }

    /**
     * 根据合同主键ID查询变更记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentChangeRecordVO> queryDetailRecord(@RequestParam Long id) {
        RentChangeRecordVO changeRecordVO = rentChangeService.queryChangeRecord(id);
        return CommonResponse.success(changeRecordVO);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentChangeVO> vos) {
        rentChangeService.deleteRentChange(vos);
        return CommonResponse.success("删除成功");
    }
}
