package com.ejianc.business.equipment.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.pub.vo.PubContractVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/api/equipment/")
public class EquipmentContractApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPurchaseContractService purchaseContractService;

	@Autowired
	private IPurchaseSettlementService purchaseSettlementService;

	@Autowired
	private IRentContractService rentContractService;

	@Autowired
	private IPurchaseSettlementService purchaseSettleService;

	@Autowired
	private IRentSettlementService rentSettleService;
	@Autowired
	private ISupplierApi supplierApi;

	@Autowired
	private ICustomerApi customerApi;

	@PostMapping(value = "getContract")
	public CommonResponse<JSONObject> getContract(@RequestBody QueryParam param) {
		try {
			/** 模糊搜索配置字段示例 */
			List<String> fuzzyFields = param.getFuzzyFields();
			fuzzyFields.add("contractName");
			fuzzyFields.add("billCode");
			fuzzyFields.add("orgName");
			fuzzyFields.add("employeeName");
			fuzzyFields.add("customerName");
			fuzzyFields.add("supplierName");
			param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			//已生效状态的单据
			param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));

			IPage<PurchaseContractEntity> pageData = purchaseContractService.queryPage(param, false);

			List<PurchaseContractEntity> contractEntityList = pageData.getRecords();
			List<PubContractVO> contractVOList = new ArrayList<>();
			for (PurchaseContractEntity entity : contractEntityList) {
				PubContractVO vo = new PubContractVO();
				vo.setId(entity.getId());
				vo.setBillCode(entity.getBillCode());
				vo.setContractName(entity.getContractName());
				vo.setContractMny(entity.getContractTaxMny());
				vo.setContractType(2);
				vo.setPurchaseType(entity.getPurchaseType());
				vo.setProjectId(entity.getProjectId());
				vo.setOrgId(entity.getOrgId());
				vo.setReceiveUnitId(entity.getSupplierId());
				vo.setSumInvoiceMny(entity.getSumInvoiceTaxMny());
				vo.setSumPayMny(entity.getSumPayMny());
				vo.setSumSettleMny(entity.getSumSettlementTaxMny());
				vo.setPayScale(entity.getPayScale());
				contractVOList.add(vo);
			}

			JSONObject page = new JSONObject();
			page.put("records", contractVOList);
			page.put("total", pageData.getTotal());
			page.put("current", pageData.getCurrent());
			page.put("size", pageData.getSize());
			page.put("pages", pageData.getPages());

			return CommonResponse.success("查询列表数据成功！", page);
		} catch (Exception e) {
			logger.error("系统异常：" + e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	@PostMapping(value = "getContractSettle")
	public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam param) {
		try {
			/** 模糊搜索配置字段示例 */
			List<String> fuzzyFields = param.getFuzzyFields();
			fuzzyFields.add("billCode");
			fuzzyFields.add("orgName");
			fuzzyFields.add("employeeName");
			fuzzyFields.add("customerName");
			fuzzyFields.add("supplierName");
			param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			//已生效状态的单据
			param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));

			IPage<PurchaseSettlementEntity> pageData = purchaseSettleService.queryPage(param, false);
			List<PurchaseSettlementEntity> entityList = pageData.getRecords();
			List<PubContractSettleVO> voList = new ArrayList<>();
			for (PurchaseSettlementEntity entity : entityList) {
				PubContractSettleVO vo = new PubContractSettleVO();
				vo.setId(entity.getId());
				vo.setBillCode(entity.getBillCode());
				vo.setSettleMny(MathUtil.safeSub(entity.getSettlementTaxMny(), entity.getOffsetMny()));
				vo.setCreateUserCode(entity.getCreateUserCode());
				vo.setCreateTime(entity.getCreateTime());
				voList.add(vo);
			}
			JSONObject page = new JSONObject();
			page.put("records", voList);
			page.put("total", pageData.getTotal());
			page.put("current", pageData.getCurrent());
			page.put("size", pageData.getSize());
			page.put("pages", pageData.getPages());
			return CommonResponse.success("查询列表数据成功！", page);
		} catch (Exception e) {
			logger.error("系统异常：" + e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	@PostMapping(value = "getRentSettle")
	public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam param) {
		try {
			/** 模糊搜索配置字段示例 */
			List<String> fuzzyFields = param.getFuzzyFields();
			fuzzyFields.add("billCode");
			fuzzyFields.add("orgName");
			fuzzyFields.add("employeeName");
			fuzzyFields.add("customerName");
			fuzzyFields.add("supplierName");
			param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
			param.getOrderMap().put("createTime", QueryParam.DESC);
			//已生效状态的单据
			param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));

			IPage<RentSettlementEntity> pageData = rentSettleService.queryPage(param, false);
			List<RentSettlementEntity> entityList = pageData.getRecords();
			List<PubContractSettleVO> voList = new ArrayList<>();
			for (RentSettlementEntity entity : entityList) {
				PubContractSettleVO vo = new PubContractSettleVO();
				vo.setId(entity.getId());
				vo.setBillCode(entity.getBillCode());
				vo.setSettleMny(MathUtil.safeSub(entity.getSettlementTaxMny(), entity.getOffsetMny()));
				vo.setCreateUserCode(entity.getCreateUserCode());
				vo.setCreateTime(entity.getCreateTime());
				voList.add(vo);
			}
			JSONObject page = new JSONObject();
			page.put("records", voList);
			page.put("total", pageData.getTotal());
			page.put("current", pageData.getCurrent());
			page.put("size", pageData.getSize());
			page.put("pages", pageData.getPages());
			return CommonResponse.success("查询列表数据成功！", page);
		} catch (Exception e) {
			logger.error("系统异常：" + e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备采购合同累计付款金额、累计预付款金额
	 * @Param contractId  合同id
	 * @Param payMny  本期已付款金额，正为回写，负为逆回写
	 * @param prepayMny 本期预付款金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updatePurchaseContractSumPayMny")
	public CommonResponse<String> updatePurchaseContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
																  @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny) {
		PurchaseContractEntity entity = purchaseContractService.selectById(contractId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备采购合同！");
		}
		//累计付款金额
		BigDecimal sumPayMny = entity.getSumPayMny();
		sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
		entity.setSumPayMny(sumPayMny);
		//累计预付款金额
		BigDecimal sumPrepayMny = entity.getSumPrepayMny();
		sumPrepayMny = MathUtil.safeAdd(sumPrepayMny, prepayMny);
		entity.setSumPrepayMny(sumPrepayMny);
		purchaseContractService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备采购合同累计付款金额、累计预付款金额成功！");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备租赁合同累计付款金额、累计预付款金额
	 * @Param contractId  合同id
	 * @Param payMny  本期已付款金额，正为回写，负为逆回写
	 * @param prepayMny 本期预付款金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updateRentContractSumPayMny")
	public CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
															  @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny) {
		RentContractEntity entity = rentContractService.selectById(contractId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备租赁合同！");
		}
		//累计付款金额
		BigDecimal sumPayMny = entity.getSumPayMny();
		sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
		entity.setSumPayMny(sumPayMny);
		//累计预付款金额
		BigDecimal sumPrepayMny = entity.getSumPrepayMny();
		sumPrepayMny = MathUtil.safeAdd(sumPrepayMny, prepayMny);
		entity.setSumPrepayMny(sumPrepayMny);
		rentContractService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备租赁合同累计付款金额、累计预付款金额成功！");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备采购结算单累计付款金额
	 * @Param settleId  结算单id
	 * @Param payMny  本期已付款金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updatePurchaseSettleSumPayMny")
	public CommonResponse<String> updatePurchaseSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
																@RequestParam("payMny") BigDecimal payMny) {
		PurchaseSettlementEntity entity = purchaseSettleService.selectById(settleId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备采购结算单！");
		}
		//累计付款金额
		BigDecimal sumPayMny = entity.getSumPayMny();
		sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
		entity.setSumPayMny(sumPayMny);
		purchaseSettleService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备采购结算单累计付款金额成功！");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备租赁结算单累计付款金额
	 * @Param settleId  结算单id
	 * @Param payMny  本期已付款金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updateRentSettleSumPayMny")
	public CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
															@RequestParam("payMny") BigDecimal payMny) {
		RentSettlementEntity entity = rentSettleService.selectById(settleId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备租赁结算单！");
		}
		//累计付款金额
		BigDecimal sumPayMny = entity.getSumPayMny();
		sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
		entity.setSumPayMny(sumPayMny);
		rentSettleService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备租赁结算单累计付款金额成功！");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备采购结算单累计付款金额、剩余可申请金额
	 * @Param settleId  结算单id
	 * @Param applyMny  本期申请金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updatePurchaseSettleSumApplyMny")
	public CommonResponse<String> updatePurchaseSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
																@RequestParam("applyMny") BigDecimal applyMny) {
		PurchaseSettlementEntity entity = purchaseSettleService.selectById(settleId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备采购结算单！");
		}
		//累计申请金额
		BigDecimal sumApplyMny = entity.getSumApplyMny();
		sumApplyMny = MathUtil.safeAdd(sumApplyMny, applyMny);
		entity.setSumApplyMny(sumApplyMny);
		//剩余可申请金额
		BigDecimal surplusApplyMny = MathUtil.safeSub(MathUtil.safeSub(entity.getSettlementTaxMny(), entity.getOffsetMny()), applyMny);
		entity.setSurplusApplyMny(surplusApplyMny);
		purchaseSettleService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备采购结算单累计申请金额、剩余可申请金额成功！");
	}

	/**
	 * @Author yqls
	 * @Date 2020/7/4
	 * @Description 回写设备租赁结算单累计申请金额、剩余可申请金额
	 * @Param settleId  结算单id
	 * @Param payMny  本期已付款金额，正为回写，负为逆回写
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@GetMapping(value = "updateRentSettleSumApplyMny")
	public CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
															@RequestParam("applyMny") BigDecimal applyMny) {
		RentSettlementEntity entity = rentSettleService.selectById(settleId);
		if (entity == null) {
			return CommonResponse.error("没有找到相应设备租赁结算单！");
		}
		//累计申请金额
		BigDecimal sumApplyMny = entity.getSumApplyMny();
		sumApplyMny = MathUtil.safeAdd(sumApplyMny, applyMny);
		entity.setSumApplyMny(sumApplyMny);
		//剩余可申请金额
		BigDecimal surplusApplyMny = MathUtil.safeSub(MathUtil.safeSub(entity.getSettlementTaxMny(), entity.getOffsetMny()), applyMny);
		entity.setSurplusApplyMny(surplusApplyMny);
		rentSettleService.saveOrUpdate(entity, false);
		return CommonResponse.success("回写设备租赁结算单累计申请金额、剩余可申请金额成功！");
	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票审批通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "afterApproveInvoiceReceive")
	public CommonResponse<JSONObject> afterApproveInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		PurchaseContractEntity entity = purchaseContractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
			LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(PurchaseContractEntity::getId, contractId);
			updateWrapper.set(PurchaseContractEntity::getSumInvoiceMny, sumInvoiceMny.add(invoiceMny));
			updateWrapper.set(PurchaseContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.add(invoiceTaxMny));
			boolean flag = purchaseContractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}

	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票弃审通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "afterRevocationInvoiceReceive")
	public CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		PurchaseContractEntity entity = purchaseContractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();

			LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(PurchaseContractEntity::getId, contractId);
			updateWrapper.set(PurchaseContractEntity::getSumInvoiceMny, sumInvoiceMny.subtract(invoiceMny));
			updateWrapper.set(PurchaseContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.subtract(invoiceTaxMny));
			boolean flag = purchaseContractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}
	}
	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票审批通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "rentAfterApproveInvoiceReceive")
	public CommonResponse<JSONObject> rentAfterApproveInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		RentContractEntity entity = rentContractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
			LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(RentContractEntity::getId, contractId);
			updateWrapper.set(RentContractEntity::getSumInvoiceMny, sumInvoiceMny.add(invoiceMny));
			updateWrapper.set(RentContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.add(invoiceTaxMny));
			boolean flag = rentContractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}

	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 收票弃审通过后更新设备采购合同开票金额等字段
	 * @Param contractId  合同id
	 * @Param invoiceMny、invoiceTaxMny  收票金额
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@PostMapping(value = "rentAfterRevocationInvoiceReceive")
	public CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(@RequestParam("contractId") Long contractId, @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny) {
		RentContractEntity entity = rentContractService.selectById(contractId);
		if (null != entity) {
			BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
			BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();

			LambdaUpdateWrapper<RentContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(RentContractEntity::getId, contractId);
			updateWrapper.set(RentContractEntity::getSumInvoiceMny, sumInvoiceMny.subtract(invoiceMny));
			updateWrapper.set(RentContractEntity::getSumInvoiceTaxMny, sumInvoiceTaxMny.subtract(invoiceTaxMny));
			boolean flag = rentContractService.update(updateWrapper);
			if (flag) {
				return CommonResponse.success("更新成功");
			} else {
				return CommonResponse.error("更新异常");
			}
		} else {
			return CommonResponse.error("更新异常!未获取到单据信息");
		}
	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 租赁合同跳转收票, 根据主键查询合同相关信心
	 * @Param contractId  合同id
	 */
	@GetMapping(value = "getRentContractById")
	public CommonResponse<ContractResVO> getRentContractById(@RequestParam("contractId") Long contractId) {
		RentContractEntity rentContractEntity = rentContractService.selectById(contractId);
        ContractResVO rentContractVO = BeanMapper.map(rentContractEntity, ContractResVO.class);
		if (null != rentContractEntity) {
			CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(rentContractEntity.getSupplierId());
			if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                rentContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
			}
			CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(rentContractEntity.getCustomerId());
			if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                rentContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());

			}
		} else {
			return CommonResponse.error("获取合同信息失败!");
		}

		return CommonResponse.success("获取合同信息成功",rentContractVO);
	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 租赁合同跳转收票, 根据主键查询合同相关信心
	 * @Param contractId  合同id
	 */
	@GetMapping(value = "getPurchaseContractById")
	public CommonResponse<ContractResVO> getPurchaseContractById(@RequestParam("contractId") Long contractId) {
		PurchaseContractEntity purchaseContractEntity = purchaseContractService.selectById(contractId);
		ContractResVO rentContractVO = BeanMapper.map(purchaseContractEntity, ContractResVO.class);
		if (null != purchaseContractEntity) {
			CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(purchaseContractEntity.getSupplierId());
			if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
				rentContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
			}
			CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(purchaseContractEntity.getCustomerId());
			if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
				rentContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());

			}
		} else {
			return CommonResponse.error("获取合同信息失败!");
		}

		return CommonResponse.success("获取合同信息成功",rentContractVO);
	}

	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 根据条件查询结算单累计冲抵金额
	 * @Param contractId  合同id
	 */
	@GetMapping(value = "getPurchaseSettlementById")
	public CommonResponse<SettlementVO> getPurchaseSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId) {
		SettlementVO vo = new SettlementVO();
		vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP));
		LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
		lambdachange.eq(PurchaseSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
		lambdachange.eq(PurchaseSettlementEntity::getContractId,contractId);
		lambdachange.eq(PurchaseSettlementEntity::getOrgId,orgId);
		lambdachange.in(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
		List<PurchaseSettlementEntity> list = purchaseSettlementService.list(lambdachange);
		if(CollectionUtils.isNotEmpty(list)){
			final BigDecimal[] sumOffsetMny = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
			list.forEach(e-> {
				sumOffsetMny[0] = sumOffsetMny[0].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
			});
			//累计冲抵金额
			vo.setSumOffsetMny(sumOffsetMny[0]);
		}
		return CommonResponse.success("获取信息成功",vo);
	}
	/**
	 * @Author sunyj
	 * @Date 2020/7/4
	 * @Description 根据条件查询结算单累计冲抵金额
	 * @Param contractId  合同id
	 */
	@GetMapping(value = "getRentSettlementById")
	public CommonResponse<SettlementVO> getRentSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId) {
		SettlementVO vo = new SettlementVO();
		vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP));
		LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
		lambdachange.eq(RentSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
		lambdachange.eq(RentSettlementEntity::getContractId,contractId);
		lambdachange.eq(RentSettlementEntity::getOrgId,orgId);
		lambdachange.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
		List<RentSettlementEntity> list = rentSettleService.list(lambdachange);
		if(CollectionUtils.isNotEmpty(list)){
			final BigDecimal[] sumOffsetMny = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
			list.forEach(e-> {
				sumOffsetMny[0] = sumOffsetMny[0].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
			});
			//累计冲抵金额
			vo.setSumOffsetMny(sumOffsetMny[0]);
		}
		return CommonResponse.success("获取信息成功",vo);
	}
}


