package com.ejianc.business.equipment.service;

import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 设备合同结算表 服务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public interface IPurchaseSettlementService extends IBaseService<PurchaseSettlementEntity> {

    /**
     * 保存或修改信息
     *
     * @param PurchaseSettlementVo
     * @return
     */
    CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO PurchaseSettlementVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    PurchaseSettlementVO queryDetail(Long id);

    PurchaseSettlementVO queryDetails(Long id);

    PurchaseSettlementRecordVO querySettlementRecord(Long id);
    /**
     * 删除信息
     *
     * @param vos
     */
    void deletePurchaseSettlement(List<PurchaseSettlementVO> vos);
}
