package com.ejianc.business.equipment.service.impl;

import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.service.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备合同变更单审批操作业务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("rentChange")
public class RentChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;

    @Autowired
    private IRentChangeService rentChangeService;

    @Autowired
    private IRentContractClauseService rentContractClauseService;

    @Autowired
    private IRentContractFeeService rentContractFeeService;

    @Autowired
    private IRentRecordService rentRecordService;


    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        RentChangeEntity changeEntity = rentChangeService.selectById(billId);
        //1，先复制合同表到合同历史表
        RentContractEntity contractEntity = rentContractService.selectById(changeEntity.getContractId());
        RentRecordEntity recordEntity = BeanMapper.map(contractEntity, RentRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:"+changeEntity+"  contractEntity:"+contractEntity);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getRentdetail())){
            recordEntity.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentfee())){
            recordEntity.getRentfee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getRentclause())){
            recordEntity.getRentclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        rentRecordService.saveOrUpdate(recordEntity,false);
        changeEntity.setChangeTime(new Date());
        rentChangeService.saveOrUpdate(changeEntity,false);
        logger.info("进入审批同意后回写--2");
        //2，回写合同，变更状态改为已变更，并回写字段
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setContractStatus(changeEntity.getContractStatus());

        rentContractClauseService.deleteByContractId(changeEntity.getContractId());
        rentContractFeeService.deleteByContractId(changeEntity.getContractId());
        if(CollectionUtils.isNotEmpty(changeEntity.getRentdetail())){
            logger.info("复制子表开始--"+changeEntity.getRentdetail());
            changeEntity.getRentdetail().forEach(vo -> {
                logger.info("复制子表--"+vo.getContractDetailId()+"---type"+vo.getChangeType());
                vo.setId(vo.getContractDetailId());
            });
            List<RentContractDetailEntity> list = BeanMapper.mapList(changeEntity.getRentdetail(),RentContractDetailEntity.class);
            contractEntity.setRentdetail(list);

            contractEntity.getRentdetail().forEach(vo -> {
                logger.info("复制合同子表--"+vo.getId()+"---type"+vo.getChangeType());
            });
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getRentfee())){
            changeEntity.getRentfee().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setRentfee(BeanMapper.mapList(changeEntity.getRentfee(),RentContractFeeEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getRentclause())){
            changeEntity.getRentclause().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setRentclause(BeanMapper.mapList(changeEntity.getRentclause(),RentContractClauseEntity.class));
        }
        boolean flag =  rentContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        if(flag){
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }



}
