package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.bean.RentUseRecordFeeEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordDetailMapper;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordFeeService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordDetailVO;
import com.ejianc.business.equipment.vo.RentUseRecordFeeVO;
import com.ejianc.business.equipment.vo.RentUseRecordRefVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 设备明细 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@Service("RentUseRecordDetailService")
public class RentUseRecordDetailServiceImpl extends BaseServiceImpl<RentUseRecordDetailMapper, RentUseRecordDetailEntity> implements IRentUseRecordDetailService {
    @Autowired
    private IRentUseRecordFeeService rentUseRecordFeeService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Override
    public RentUseRecordRefVO useDetail(Long id) {
        //获取使用记录billcode
        RentUseRecordEntity rentUseRecordEntity = rentUseRecordService.getById(id);
        RentUseRecordRefVO rentUseRecordRefVO = new RentUseRecordRefVO();
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<RentUseRecordDetailEntity> lambda = Wrappers.<RentUseRecordDetailEntity>lambdaQuery();
        lambda.eq(RentUseRecordDetailEntity::getTenantId, tenantId);
        lambda.eq(RentUseRecordDetailEntity::getUseId, id);
        List<RentUseRecordDetailEntity> entities = super.list(lambda);
        List<RentUseRecordDetailVO> rentUseRecordVo = BeanMapper.mapList(entities,RentUseRecordDetailVO.class);
        for (RentUseRecordDetailVO rentUseRecordDetailVO : rentUseRecordVo){
            rentUseRecordDetailVO.setUseCode(rentUseRecordEntity.getBillCode());
            rentUseRecordDetailVO.setSourceName("设备使用记录-"+rentUseRecordEntity.getBillCode());
        }
        rentUseRecordRefVO.setRentdetail(rentUseRecordVo);
        LambdaQueryWrapper<RentUseRecordFeeEntity> feeWrapper = Wrappers.<RentUseRecordFeeEntity>lambdaQuery();
        feeWrapper.eq(RentUseRecordFeeEntity::getTenantId, tenantId);
        feeWrapper.eq(RentUseRecordFeeEntity::getUseId, id);
        List<RentUseRecordFeeEntity> feeEntities = rentUseRecordFeeService.list(feeWrapper);
        List<RentUseRecordFeeVO> feeVOList = BeanMapper.mapList(feeEntities,RentUseRecordFeeVO.class);
        for (RentUseRecordFeeVO rentUseRecordFeeVO : feeVOList){
            rentUseRecordFeeVO.setUseCode(rentUseRecordEntity.getBillCode());
            rentUseRecordFeeVO.setSourceName("设备使用记录-"+rentUseRecordEntity.getBillCode());
        }
        rentUseRecordRefVO.setRentfee(feeVOList);
        return rentUseRecordRefVO;
    }
}
