package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.service.impl.RentChangeBpmServiceImpl;
import com.ejianc.business.equipment.vo.ApplyDetailVO;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.equipment.vo.RentUseRecordDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备使用申请表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@RestController
@RequestMapping("apply")
public class ApplyController {
    @Autowired
    private IApplyService applyService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 新增或者修改
     *
     * @param applyVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVo) {
        return applyService.saveOrUpdate(applyVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(@RequestParam Long id) {
        ApplyVO applyVo = applyService.queryDetail(id);
        return CommonResponse.success(applyVo);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        applyService.deleteApply(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ApplyEntity> pageData= applyService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ApplyVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 设备使用申请树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/applyRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> applyRefTree(@RequestParam(required = false) String searchText,
                                                  @RequestParam(value = "condition", required = false) String condition) {
        List<ApplyVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            Long projectId = null;
            String signDate = null;
            if(StringUtils.isNotBlank(condition)) {
                Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
                if(null != conditionMap.get("projectId")) {
                    projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    params.put("projectId", projectId);
                }
                if(null != conditionMap.get("signDate")) {
                    signDate = conditionMap.get("signDate").toString().substring(0,10);
                    params.put("signDate", signDate);
                }
            }
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            List<String> billState = new ArrayList<>();
            dataList = applyService.queryListTree(params);
            List<Map> map = new ArrayList<>();
            if (dataList != null && dataList.size() > 0){
                for (ApplyVO applyVO : dataList){
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String plandate = formatter.format(applyVO.getPlanDate());
                    applyVO.setName(applyVO.getBillCode()+"+"+plandate);
                }
                map = BeanMapper.mapList(dataList, Map.class);
                return ResultAsTree.createTreeData(map);
            }else {
                return ResultAsTree.createTreeData(map);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 设备使用申请编号+日期属性结构
     */
    @RequestMapping(value = "/applyTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ApplyVO>> applyTree() {
        List<ApplyVO> list = applyService.applyTree();
        return CommonResponse.success(list);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<ApplyEntity> pageData= applyService.queryPage(param,false);
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            List<ApplyVO> list = BeanMapper.mapList(pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", list);
            ExcelExport.getInstance().export("applyExport.xlsx", beans, response);
        }
    }
}
