package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.mapper.RentSettlementMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.vo.RentSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Service("RentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "EQUIPMENT_RENT_SETTLEMENT";

    @Autowired
    private IRentContractService rentContractService;


    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
//变更合同只能存在一条未生效的
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的结算单!");
        }

        LambdaQueryWrapper<RentSettlementEntity> lambdachange2 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange2.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange2.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange2.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(RentSettlementEntity ::getSettlementDate,rentSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if(num2>0){
            throw new BusinessException("结算日期必须大于该合同对应最新结算日期!");
        }
        BigDecimal sumSettlementTaxMny = rentSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumSettlementTaxMny();
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSettlementTaxMny();
        BigDecimal contractTaxMny = rentSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getContractTaxMny();
        if(contractTaxMny.compareTo(sumSettlementTaxMny.add(settlementTaxMny))<0){
            throw new BusinessException("该合同结算金额已经超过合同金额!");
        }
        BigDecimal sumPayMny = rentSettlementVo.getSumPayMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumPayMny();//预付款金额
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:rentSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal sumOffsetMny = rentSettlementVo.getSumOffsetMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumOffsetMny();//累计冲抵金额

        if(StringUtils.isEmpty(rentSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity = BeanMapper.map(rentSettlementVo, RentSettlementEntity.class);
        super.saveOrUpdate(entity,false);
        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0){
            List<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail){
                if (rentSettlementDetailEntity.getSource() == 3){
                    useIds.add(rentSettlementDetailEntity.getUseId());
                }

            }
            //更新设备使用记录-为已引用,
            if (useIds != null && useIds.size() > 0){
                LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(RentUseRecordEntity::getId, useIds);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, 1);//(1:是，0：否)
                boolean flag = rentUseRecordService.update(updateWrapper);
            }

        }
        return CommonResponse.success(BeanMapper.map(entity, RentSettlementVO.class));
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = super.selectById(id);
        RentSettlementVO rentSettlementVo = BeanMapper.map(entity, RentSettlementVO.class);
        return rentSettlementVo;
    }
    @Override
    public RentSettlementVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentSettlementVO rentSettlementVO = BeanMapper.map(entity, RentSettlementVO.class);
        //新增逻辑处理
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        return rentSettlementVO;
    }
    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        //获取删除的主键
        List<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos){
            ids.add(rentSettlementVO.getId());
        }
        if (ids != null && ids.size() > 0){
            LambdaQueryWrapper<RentSettlementDetailEntity> lambda = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List<RentSettlementDetailEntity> rentSettlementDetailEntities = rentSettlementDetailService.list(lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0){
                List<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities){
                    if (rentSettlementDetailEntity.getSource() == 3){
                        useIds.add(rentSettlementDetailEntity.getUseId());
                    }
                }
                if (useIds != null && useIds.size() > 0){
                    LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(RentUseRecordEntity::getId, useIds);
                    updateWrapper.set(RentUseRecordEntity::getUseFlag, 0);//(1:是，0：否)
                    boolean flag = rentUseRecordService.update(updateWrapper);

                }

            }
        }

        super.removeByIds(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal sumSettlementTaxMny = entity.getSumSettlementTaxMny()==null?BigDecimal.ZERO:entity.getSumSettlementTaxMny();//累计结算金额
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSumSettlementTaxMny(sumSettlementTaxMny);
        if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)>0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
            vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId,id);
        lambda.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            List<RentSettlementVO> rentSettlementVOList = BeanMapper.mapList(entities, RentSettlementVO.class);
            rentSettlementVOList.forEach(vos -> {
                vos.setBillStateName(BillStateEnum.getEnumByStateCode(vos.getBillState()).getDescription());
            });
            vo.setSettlementRecord(rentSettlementVOList);
        }
        return vo;
    }
}
