package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("PurchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";

    @Autowired
    private IPurchaseChangeService purchaseChangeService;


    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = BeanMapper.map(purchaseContractVo, PurchaseContractEntity.class);
        String operateType = null;
        List<PurchaseContractEntity> entities = null;
        List<PurchaseChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(purchaseContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.ne(PurchaseContractEntity::getId, purchaseContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,purchaseContractVo.getId()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
//        entity.setDr(0);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = super.selectById(id);
        PurchaseContractVO purchaseContractVo = BeanMapper.map(entity, PurchaseContractVO.class);
        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseContractVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseContractDetailVO.class));
        }
        return purchaseContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()),false);
    }
}