package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.vo.RentContractDetailVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";

//    @Autowired
//    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = BeanMapper.map(rentContractVo, RentContractEntity.class);
        String operateType = null;
        List<RentContractEntity> entities = null;
        List<RentChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(rentContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,rentContractVo.getId()));
            entitiesc = rentChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            entitiesc = rentChangeService.queryList(queryParam,false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
//        entity.setDr(0);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = super.selectById(id);
        RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);
        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId,id);
        lambda.ne(RentContractDetailEntity::getChangeType,"3");
        details = rentContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            rentContractVo.setRentdetail(BeanMapper.mapList(details,RentContractDetailVO.class));
        }
        return rentContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()),false);
    }
}
