package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.mapper.RentSettlementMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.vo.RentSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.equipment.vo.RentSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@Service("RentSettlementService")
public class RentSettlementServiceImpl extends BaseServiceImpl<RentSettlementMapper, RentSettlementEntity> implements IRentSettlementService {
    private static final String RENT_SETTLEMENT_BILL_CODE = "EQUIPMENT_RENT_SETTLEMENT";
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private IRentSettlementDetailService rentSettlementDetailService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Override
    public CommonResponse<RentSettlementVO> saveOrUpdate(RentSettlementVO rentSettlementVo) {
        //保存时校验合同version是否一致
        if(rentSettlementVo.getContractVersion()!=null&&rentSettlementVo.getContractVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    RentContractEntity contractEntity = rentContractService.selectById(rentSettlementVo.getContractId());
                    Integer version = contractEntity.getVersion()==null?0:contractEntity.getVersion();
                    Integer conVersion = rentSettlementVo.getContractVersion();
                    if(!version.equals(conVersion)){
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(rentSettlementVo.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        lambdachange.eq(RentSettlementEntity::getOrgId,rentSettlementVo.getOrgId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }

        LambdaQueryWrapper<RentSettlementEntity> lambdachange2 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange2.eq(RentSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(RentSettlementEntity::getContractId,rentSettlementVo.getContractId());
        lambdachange2.eq(RentSettlementEntity::getOrgId,rentSettlementVo.getOrgId());
        if(null!=rentSettlementVo.getId()&&rentSettlementVo.getId()>0){
            lambdachange2.ne(RentSettlementEntity::getId,rentSettlementVo.getId());
        }
        lambdachange2.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(RentSettlementEntity ::getSettlementDate,rentSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if(num2>0){
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = rentSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = rentSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:rentSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = rentSettlementVo.getSymny()==null?BigDecimal.ZERO:rentSettlementVo.getSymny();//剩余冲抵金额
        if(offsetMny.compareTo(syMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if(offsetMny.compareTo(settlementTaxMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if(StringUtils.isEmpty(rentSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设备使用记录引用标识修改
        LambdaQueryWrapper<RentSettlementDetailEntity> queryWrapperDetail = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
        queryWrapperDetail.eq(RentSettlementDetailEntity::getSettlementId, rentSettlementVo.getId());
        List<RentSettlementDetailEntity> detailList = rentSettlementDetailService.list(queryWrapperDetail);
        List<Long> useOldIdList = new ArrayList<>();
        if (detailList != null && detailList.size() > 0){
            for (RentSettlementDetailEntity rentSettlementDetailEntity : detailList) {
                if (rentSettlementDetailEntity.getSource() == 3) {
                    useOldIdList.add(rentSettlementDetailEntity.getUseId());
                }
            }
            if (useOldIdList != null && useOldIdList.size() > 0){
                LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(RentUseRecordEntity::getId, useOldIdList);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, 0);//(1:是，0：否)
                boolean flag = rentUseRecordService.update(updateWrapper);
            }
        }

        entity = BeanMapper.map(rentSettlementVo, RentSettlementEntity.class);
        super.saveOrUpdate(entity,false);

        List<RentSettlementDetailEntity> rentdetail = entity.getRentdetail();
        if (rentdetail != null && rentdetail.size() > 0) {
            List<Long> useIds = new ArrayList<Long>();
            for (RentSettlementDetailEntity rentSettlementDetailEntity : rentdetail) {
                if (rentSettlementDetailEntity.getSource() == 3) {
                    useIds.add(rentSettlementDetailEntity.getUseId());
                }

            }
            //更新设备使用记录-为已引用,
            if (useIds != null && useIds.size() > 0) {
                LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.in(RentUseRecordEntity::getId, useIds);
                updateWrapper.set(RentUseRecordEntity::getUseFlag, 1);//(1:是，0：否)
                boolean flag = rentUseRecordService.update(updateWrapper);
            }
        }

        RentSettlementVO vo = BeanMapper.map(entity, RentSettlementVO.class);
        BigDecimal c = rentSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getContractTaxMny();
        BigDecimal cc = rentSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            vo.setSumSettlementTaxMny(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success(vo);
    }

    @Override
    public RentSettlementVO queryDetail(Long id) {
        RentSettlementEntity entity = super.selectById(id);
        RentSettlementVO rentSettlementVo = BeanMapper.map(entity, RentSettlementVO.class);
        BigDecimal c = rentSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getContractTaxMny();
        BigDecimal cc = rentSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            rentSettlementVo.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        rentSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return rentSettlementVo;
    }
    @Override
    public RentSettlementVO queryDetails(Long id) {
        RentContractEntity entity = rentContractService.selectById(id);
        RentSettlementVO rentSettlementVO = BeanMapper.map(entity, RentSettlementVO.class);
        //新增逻辑处理
        rentSettlementVO.setContractId(rentSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        rentSettlementVO.setId(null);
        rentSettlementVO.setBillCode(null);
        rentSettlementVO.setBillState(null);
        rentSettlementVO.setCreateUserCode(null);
        rentSettlementVO.setCreateTime(null);
        rentSettlementVO.setSettlementDate(new Date());
        rentSettlementVO.setUpdateUserCode(null);
        rentSettlementVO.setUpdateTime(null);
        rentSettlementVO.setRentdetail(null);
        rentSettlementVO.setRentfee(null);
        rentSettlementVO.setTaxMny(BigDecimal.ZERO);

        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id,entity.getOrgId());
        if(!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        rentSettlementVO.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        rentSettlementVO.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<RentSettlementEntity> lambdachange = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambdachange.eq(RentSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(RentSettlementEntity::getContractId,id);
        lambdachange.eq(RentSettlementEntity::getOrgId,entity.getOrgId());
        lambdachange.in(RentSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<RentSettlementEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            rentSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            rentSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal sumOffsetMnys = rentSettlementVO.getSumOffsetMny()==null?BigDecimal.ZERO:rentSettlementVO.getSumOffsetMny();
        if(rentSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            rentSettlementVO.setSymny(rentSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = rentSettlementVO.getContractTaxMny()==null?BigDecimal.ZERO:rentSettlementVO.getContractTaxMny();
        BigDecimal cc = rentSettlementVO.getSumSettlementTaxMny()==null?BigDecimal.ZERO:rentSettlementVO.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            rentSettlementVO.setSumSettleRate(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        return rentSettlementVO;
    }
    @Override
    public void deleteRentSettlement(List<RentSettlementVO> vos) {
        //获取删除的主键
        List<Long> ids = new ArrayList<Long>();
        for (RentSettlementVO rentSettlementVO : vos){
            ids.add(rentSettlementVO.getId());
        }
        if (ids != null && ids.size() > 0){
            LambdaQueryWrapper<RentSettlementDetailEntity> lambda = Wrappers.<RentSettlementDetailEntity>lambdaQuery();
            lambda.in(RentSettlementDetailEntity::getSettlementId, ids);
            List<RentSettlementDetailEntity> rentSettlementDetailEntities = rentSettlementDetailService.list(lambda);
            if (rentSettlementDetailEntities != null && rentSettlementDetailEntities.size() > 0){
                List<Long> useIds = new ArrayList<Long>();
                for (RentSettlementDetailEntity rentSettlementDetailEntity : rentSettlementDetailEntities){
                    if (rentSettlementDetailEntity.getSource() == 3){
                        useIds.add(rentSettlementDetailEntity.getUseId());
                    }
                }
                if (useIds != null && useIds.size() > 0){
                    LambdaUpdateWrapper<RentUseRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.in(RentUseRecordEntity::getId, useIds);
                    updateWrapper.set(RentUseRecordEntity::getUseFlag, 0);//(1:是，0：否)
                    boolean flag = rentUseRecordService.update(updateWrapper);

                }

            }
        }
        super.removeByIds(vos.stream().map(RentSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public RentSettlementRecordVO querySettlementRecord(Long id) {
        RentSettlementRecordVO vo = new RentSettlementRecordVO();
        RentContractEntity entity = rentContractService.selectById(id);
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<RentSettlementEntity> lambda = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda.eq(RentSettlementEntity::getContractId,id);
        lambda.in(RentSettlementEntity::getOrgId,commonOrgIds);
        lambda.in(RentSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(RentSettlementEntity::getCreateTime);
        List<RentSettlementEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            entities.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = vo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:vo.getSumSettlementTaxMny();//累计结算金额
            if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)>0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
            }else{
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList(entities, RentSettlementVO.class));
        }
        return vo;
    }
}
