package com.ejianc.business.equipment.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.RentContractPayVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("purchaseContract")
public class PurchaseContractController {

    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService rentSettlementService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IInvoiceApi invoiceApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;


    /**
     * 新增或者修改
     *
     * @param purchaseContractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO purchaseContractVo) {
        return purchaseContractService.saveOrUpdate(purchaseContractVo);
    }

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(@RequestParam Long id) {
        PurchaseContractVO purchaseContractVo = purchaseContractService.queryDetail(id);
        return CommonResponse.success(purchaseContractVo);
    }

    /**
     * 根据主键ID查询收票记录详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryInvoiceDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        InvoiceReceiveRecordVO vo = res.getData();
        if(null!=vo){
            vo.setContractTaxMny(entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny());
        }
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID查询付款记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryPayDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        RentContractPayVO rentContractPayVO = BeanMapper.map(entity, RentContractPayVO.class);
        CommonResponse<SumPayMnyVO> sumPayMnyVOList = payContractApi.getSumPayMnyVOList(id, InvocationInfoProxy.getOrgId());
        if(!sumPayMnyVOList.isSuccess() || !sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }

        BigDecimal sumPayMny = sumPayMnyVOList.getData().getSumPayMny()==null?BigDecimal.ZERO:sumPayMnyVOList.getData().getSumPayMny();
        rentContractPayVO.setContractId(sumPayMnyVOList.getData().getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(sumPayMnyVOList.getData().getContractVOList());

        //获取累计结算
        PurchaseSettlementRecordVO settlementRecordVO = purchaseSettlementService.querySettlementRecord(id);
        BigDecimal sumSettlementTaxMny = settlementRecordVO.getSumSettlementTaxMny()==null?BigDecimal.ZERO:settlementRecordVO.getSumSettlementTaxMny();
        rentContractPayVO.setSumSettlementTaxMny(sumSettlementTaxMny);
        //获取累计收票
        CommonResponse<InvoiceReceiveRecordVO>  res = invoiceApi.getInvoiceReceiveRecord(id);
        if(!res.isSuccess() || !res.isSuccess()) {
            throw new BusinessException("获取收票信息失败！");
        }
        rentContractPayVO.setSumInvoiceTaxMny(res.getData().getInvoiceTaxMny());
        //累计未付
        rentContractPayVO.setSumUnPayMny(sumSettlementTaxMny.subtract(sumPayMny));
        return CommonResponse.success(rentContractPayVO);
    }
    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        purchaseContractService.deletePurchaseContract(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(getPageQueryParam(null));
        IPage<PurchaseContractEntity> pageData= purchaseContractService.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = purchaseContractService.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("PurchaseCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/purchaseContractRef")
    public CommonResponse<IPage<PurchaseContractVO>> projectListRefe(
                    @RequestParam(defaultValue = "1") Integer pageNumber,
                    @RequestParam(defaultValue = "10") Integer pageSize,
                    @RequestParam(value = "condition", required = false) String condition,
                    @RequestParam(value = "searchText", required = false) String searchText) {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        Long orgId = null;
        String type = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if(null != conditionMap.get("type")) {
                type = conditionMap.get("type").toString();
            }
        }
        if(type != null && "pay".equals(type)){
            // 付款申请特供版
            queryParam.getComplexParams().add(getComplexParamForPay(orgId));
        } else {
            queryParam.getComplexParams().add(getPageQueryParam(null));
        }
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        IPage<PurchaseContractEntity> pageData = purchaseContractService.queryPage(queryParam,false);
        IPage<PurchaseContractVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success("参照查询成功！", result);
    }

    /**
     * 合同状态修改
     *
     * @param purchaseContractVO
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody PurchaseContractVO purchaseContractVO) {
        LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PurchaseContractEntity::getId,purchaseContractVO.getId());
        updateWrapper.set(PurchaseContractEntity::getContractStatus, purchaseContractVO.getContractStatus());
        purchaseContractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getFuzzyFields().add("customerName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getComplexParams().add(getPageQueryParam(null));

        IPage<PurchaseContractEntity> pageData = purchaseContractService.queryPage(queryParam, false);
        Map<String, Object> beans = new HashMap<String, Object>();
        List<PurchaseContractVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class);
        }
        list.forEach(vo -> {
            if("1".equals(vo.getContractStatus())){
                vo.setContractStatus("未签订");
            }else if("2".equals(vo.getContractStatus())){
                vo.setContractStatus("履约中");
            }else if("3".equals(vo.getContractStatus())){
                vo.setContractStatus("已封账");
            }
            vo.setPurchaseTypeName("1".equals(vo.getPurchaseType())?"自采":"集采");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        if(null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }

        List<Long> parentOrgIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));
        c1.getComplexParams().add(c2);

        if(CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "2"));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        }
        return c1;
    }

    /**
     * 传入/登录组织本下自采合同 + 登录组织本上加本下集采合同
     * @param orgId     null默认登录组织
     * @return
     */
    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 传入/登录组织本下自采合同
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "1"));
        c2.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        // 登录组织本上加本下集采合同
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if(!allOrgIds.isEmpty()){
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("purchase_type", new Parameter(QueryParam.EQ, "2"));
            c3.getParams().put("org_id", new Parameter(QueryParam.IN, this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        // 生效单据
        c1.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        return c1;
    }

    /**
     * 获取当前登录组织本上加本下的所有组织ID的集合
     * @return
     */
    public List<Long> getOrgUpToDownList(){
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(orgId);
        CommonResponse<List<OrgVO>> parentOrgResp = orgApi.findParentsByOrgId(orgId);
        if(!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("查询组织本上加本下信息失败！");
        }
        List<Long> parentIds = new ArrayList<>();
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.addAll(parentOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/9/22  查询设备采购合同和设备租赁总金额
     * @Description getSubContractTotalAmount
     * @Param [projectIds]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @PostMapping("getEquipmentContractTotalAmount")
    public CommonResponse<JSONObject> getEquipmentContractTotalAmount(@RequestBody List<Long> projectIds){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
        if(ListUtil.isNotEmpty(projectIds)){
            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
        }
        List<RentContractEntity> rentContractEntities = rentContractService.queryList(queryParam,false);
        List<RentSettlementEntity> rentSettlementEntities = rentSettlementService.queryList(queryParam,false);
        queryParam.getParams().put("purchaseType",new Parameter(QueryParam.EQ,"1"));//属于项目
        List<PurchaseContractEntity> contractEntities = purchaseContractService.queryList(queryParam,false);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.queryList(queryParam,false);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(rentContractEntities)){
            for (RentContractEntity c:rentContractEntities ){
                contract = contract.add(c.getContractTaxMny());
            }
        }
        if(ListUtil.isNotEmpty(contractEntities)){
            for (PurchaseContractEntity c:contractEntities ){
                contract = contract.add(c.getContractTaxMny());
            }
        }
        if(ListUtil.isNotEmpty(rentSettlementEntities)){
            for (RentSettlementEntity c:rentSettlementEntities ){
                settle = settle.add(c.getSettlementTaxMny());
            }
        }
        if(ListUtil.isNotEmpty(purchaseSettlementEntities)){
            for (PurchaseSettlementEntity c:purchaseSettlementEntities ){
                settle = settle.add(c.getSettlementTaxMny());
            }
        }

        JSONObject back = new JSONObject();
        back.put("contract",contract);
        back.put("settle",settle);
        return CommonResponse.success(back);
    }
}
