/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rentContractWarn/"})
public class RentContractWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-equipment-frontend/#/rentContract/card?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IRentContractService rentContractService;

    @PostMapping(value={"settleWarnExecute"})
    public CommonResponse<String> settleWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u7ed3\u7b97\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u7ed3\u7b97\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u7ed3\u7b97\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.rentContractService.querySettleWarnContract(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u7ed3\u7b97\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"payWarnExecute"})
    public CommonResponse<String> payWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.rentContractService.queryPayWarnContract(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"prePayWarnExecute"})
    public CommonResponse<String> prePayWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u9884\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u9884\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u9884\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.rentContractService.queryPrePayWarnContract(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u9884\u4ed8\u6b3e\u91d1\u989d\u3011\u5927\u4e8e\u3010\u5408\u540c\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"taxWarnExecute"})
    public CommonResponse<String> taxWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u6536\u7968\u91d1\u989d\u3011\u5c0f\u4e8e\u7b49\u4e8e\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u3010\u6536\u7968\u91d1\u989d\u3011\u5c0f\u4e8e\u7b49\u4e8e\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u6536\u7968\u91d1\u989d\u3011\u5c0f\u4e8e\u7b49\u4e8e\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100.0);
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.rentContractService.queryTaxWarnContract(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u8bbe\u5907\u79df\u8d41\u5408\u540c\u3010\u6536\u7968\u91d1\u989d\u3011\u5c0f\u4e8e\u7b49\u4e8e\u3010\u4ed8\u6b3e\u91d1\u989d\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u5408\u540c\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("contractCode").toString());
            vo.setPcTitle("\u8bbe\u5907\u79df\u8d41\u5408\u540c");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", m.get("contractName").toString()).replaceAll("#contractSettlementAmt#", df.format(new BigDecimal(m.get("contractSettlementAmt").toString()))).replaceAll("#contractAmt#", df.format(new BigDecimal(m.get("contractAmt").toString()))).replaceAll("#percent#", m.get("percent").toString()).replaceAll("#overAmt#", df.format(new BigDecimal(m.get("overAmt").toString()))));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

