/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseContractService")
public class PurchaseContractServiceImpl
extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity>
implements IPurchaseContractService {
    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService settlementService;

    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)purchaseContractVo, PurchaseContractEntity.class));
        Object operateType = null;
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)purchaseContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)purchaseContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)purchaseContractVo.getId()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        entity.setPurchasedetail(null);
        PurchaseContractVO purchaseContractVo = (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId, (Object)id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType, (Object)"3");
        details = this.purchaseContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseContractVo.setPurchasedetail(BeanMapper.mapList((Iterable)details, PurchaseContractDetailVO.class));
        }
        return purchaseContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = PurchaseContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return ((PurchaseContractMapper)this.baseMapper).querySettleWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return ((PurchaseContractMapper)this.baseMapper).queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return ((PurchaseContractMapper)this.baseMapper).queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return ((PurchaseContractMapper)this.baseMapper).invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<EquipmentWarnVo> equipmentProjectOutMny(List<Long> tenantIds) {
        return ((PurchaseContractMapper)this.baseMapper).equipmentProjectOutMny(tenantIds);
    }

    @Override
    public List<EquipmentReportVo> getMonthEquipmentMny(Long projectId, Integer lastDay) {
        return ((PurchaseContractMapper)this.baseMapper).getMonthEquipmentMny(projectId, lastDay);
    }

    @Override
    public List<EquipmentReportVo> getEquipment(Long projectId) {
        BigDecimal cgmny = BigDecimal.ZERO;
        BigDecimal cgsettleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(PurchaseContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (PurchaseContractEntity ce : quoteEntities) {
            cgmny = cgmny.add(ce.getContractTaxMny());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            cgsettleMny = cgsettleMny.add(ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo = new EquipmentReportVo();
        vo.setMny(cgmny);
        vo.setNum(Integer.valueOf(quoteEntities.size()));
        vo.setSettleMny(cgsettleMny);
        BigDecimal zlmny = BigDecimal.ZERO;
        BigDecimal zlsettleMny = BigDecimal.ZERO;
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(RentContractEntity::getProjectId, (Object)projectId);
        lambda3.eq(BaseEntity::getDr, (Object)0);
        lambda3.in(RentContractEntity::getBillState, billStatus);
        List rentContractEntities = this.rentContractService.list((Wrapper)lambda3);
        for (RentContractEntity ce : rentContractEntities) {
            zlmny = zlmny.add(ce.getContractTaxMny());
        }
        LambdaQueryWrapper lambda4 = Wrappers.lambdaQuery();
        lambda4.eq(RentSettlementEntity::getProjectId, (Object)projectId);
        lambda4.eq(BaseEntity::getDr, (Object)0);
        lambda4.in(RentSettlementEntity::getBillState, billStatus);
        List rentSettlementEntities = this.settlementService.list((Wrapper)lambda4);
        for (RentSettlementEntity ce : rentSettlementEntities) {
            zlsettleMny = zlsettleMny.add(ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo2 = new EquipmentReportVo();
        vo2.setMny(zlmny);
        vo2.setNum(Integer.valueOf(rentContractEntities.size()));
        vo2.setSettleMny(zlsettleMny);
        ArrayList<EquipmentReportVo> list = new ArrayList<EquipmentReportVo>();
        list.add(vo);
        list.add(vo2);
        return list;
    }
}

