package com.ejianc.business.equipment.service;

import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.vo.RentChangeRecordVO;
import com.ejianc.business.equipment.vo.RentChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 设备合同表 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
public interface IRentChangeService extends IBaseService<RentChangeEntity> {
    /**
     * 保存或修改信息
     *
     * @param RentChangeVo
     * @return
     */
    CommonResponse<RentChangeVO> saveOrUpdate(RentChangeVO RentChangeVo);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    RentChangeVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deleteRentChange(List<RentChangeVO> vos);

    RentChangeVO queryDetails(Long id);

    RentChangeRecordVO queryChangeRecord(Long id);
}
