/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.SupplementRentContractDetailEntity;
import com.ejianc.business.equipment.bean.SupplementRentContractEntity;
import com.ejianc.business.equipment.mapper.SupplementRentContractMapper;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.ISupplementRentContractService;
import com.ejianc.business.equipment.vo.SupplementRentContractRecordVO;
import com.ejianc.business.equipment.vo.SupplementRentContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplementRentContractService")
public class SupplementRentContractServiceImpl
extends BaseServiceImpl<SupplementRentContractMapper, SupplementRentContractEntity>
implements ISupplementRentContractService {
    private static final String EQUIPMENT_SUPPLEMENT_BILL_CODE = "EQUIPMENT_RENT_BCXY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private IRentChangeService changeService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public SupplementRentContractVO addConvertByConId(Long contractId) {
        RentContractEntity entity = (RentContractEntity)((Object)this.contractService.selectById(contractId));
        SupplementRentContractVO supplementVO = new SupplementRentContractVO();
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setCustomerId(entity.getCustomerId());
        supplementVO.setCustomerName(entity.getCustomerName());
        supplementVO.setTaxRate(entity.getTaxRate());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setContractStatus("2");
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        supplementVO.setSignDate(new Date());
        supplementVO.setPayScale(entity.getPayScale());
        supplementVO.setMainContractId(entity.getId());
        supplementVO.setMainContractCode(entity.getBillCode());
        supplementVO.setMainContractName(entity.getContractName());
        supplementVO.setPurchaseOrgId(entity.getPurchaseOrgId());
        supplementVO.setPurchaseOrgName(entity.getPurchaseOrgName());
        supplementVO.setReplaceSignFlag(entity.getReplaceSignFlag());
        return supplementVO;
    }

    @Override
    public SupplementRentContractRecordVO queryDetailRecord(Long id) {
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(id));
        SupplementRentContractRecordVO recordVO = new SupplementRentContractRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setSettlementType(contractEntity.getSettlementType());
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SupplementRentContractEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(SupplementRentContractEntity::getSignDate);
        List entities = super.list((Wrapper)lambda);
        recordVO.setSupplementRecord(BeanMapper.mapList((Iterable)entities, SupplementRentContractVO.class));
        return recordVO;
    }

    @Override
    public SupplementRentContractVO insertOrUpdate(SupplementRentContractVO supplementVO) {
        LambdaQueryWrapper lambda;
        if (this.checkFinishContract(supplementVO).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u5b8c\u5de5\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\uff01");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(SupplementRentContractEntity::getMainContractId, (Object)supplementVO.getMainContractId());
        if (supplementVO.getId() != null && supplementVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)supplementVO.getId());
        }
        lambdaQuery.ne(SupplementRentContractEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementRentContractEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdaQuery);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(RentChangeEntity::getContractId, (Object)supplementVO.getMainContractId());
        lambdachange.ne(RentChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = this.changeService.count((Wrapper)lambdachange);
        if (changeNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)supplementVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                supplementVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (supplementVO.getId() != null && supplementVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementRentContractEntity::getBillCode, (Object)supplementVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(SupplementRentContractEntity::getSupplementFlag, (Object)1);
            lambda.ne(BaseEntity::getId, (Object)supplementVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementRentContractEntity::getBillCode, (Object)supplementVO.getBillCode());
            lambda.eq(SupplementRentContractEntity::getSupplementFlag, (Object)1);
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        SupplementRentContractEntity supplementEntity = (SupplementRentContractEntity)((Object)BeanMapper.map((Object)supplementVO, SupplementRentContractEntity.class));
        List<SupplementRentContractDetailEntity> beforeDetails = supplementEntity.getRentdetail();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == supplementEntity.getId()) {
            for (SupplementRentContractDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }
        super.saveOrUpdate((Object)supplementEntity, false);
        return (SupplementRentContractVO)BeanMapper.map((Object)((Object)supplementEntity), SupplementRentContractVO.class);
    }

    private Boolean checkFinishContract(SupplementRentContractVO supplementVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getId, (Object)supplementVO.getMainContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(RentContractEntity::getSettlementType, (Object)1);
        return this.contractService.list((Wrapper)lambda).size() > 0;
    }
}

