/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractClauseEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentContractFeeEntity;
import com.ejianc.business.equipment.bean.RentRecordEntity;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractClauseService;
import com.ejianc.business.equipment.service.IRentContractFeeService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentRecordService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentChange")
public class RentChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IRentContractClauseService rentContractClauseService;
    @Autowired
    private IRentContractFeeService rentContractFeeService;
    @Autowired
    private IRentRecordService rentRecordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        RentChangeEntity changeEntity = (RentChangeEntity)((Object)this.rentChangeService.selectById(billId));
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(changeEntity.getContractId()));
        RentRecordEntity recordEntity = (RentRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), RentRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getRentdetail())) {
            recordEntity.getRentdetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentfee())) {
            recordEntity.getRentfee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getRentclause())) {
            recordEntity.getRentclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        this.rentRecordService.saveOrUpdate((Object)recordEntity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        updateWrapper.set(RentChangeEntity::getChangeTime, (Object)new Date());
        this.rentChangeService.update((Wrapper)updateWrapper);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setTaxMny(changeEntity.getTaxMny());
        contractEntity.setContractStatus(changeEntity.getContractStatus());
        this.rentContractClauseService.deleteByContractId(changeEntity.getContractId());
        this.rentContractFeeService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setRentclause(null);
        contractEntity.setRentfee(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getRentdetail())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getRentdetail());
            changeEntity.getRentdetail().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getRentdetail().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setRentdetail(BeanMapper.mapList(changeEntity.getRentdetail(), RentContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getRentfee())) {
            changeEntity.getRentfee().forEach(vo -> vo.setId(null));
            contractEntity.setRentfee(BeanMapper.mapList(changeEntity.getRentfee(), RentContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getRentclause())) {
            changeEntity.getRentclause().forEach(vo -> vo.setId(null));
            contractEntity.setRentclause(BeanMapper.mapList(changeEntity.getRentclause(), RentContractClauseEntity.class));
        }
        boolean flag = this.rentContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT200610000000001", "102345678", String.valueOf(contractEntity.getId()), "BT200528000000003", "102345678");
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }
}

