/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.work.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.work.bean.RepairEntity;
import com.ejianc.business.work.bean.ReportrepairEntity;
import com.ejianc.business.work.controller.ReportrepairController;
import com.ejianc.business.work.service.IRepairService;
import com.ejianc.business.work.service.IReportrepairService;
import com.ejianc.business.work.vo.RepairVO;
import com.ejianc.business.work.vo.ReportrepairVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"repair"})
public class RepairController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ReportrepairController reportrepairController;
    @Autowired
    private IReportrepairService iReportrepairService;
    private static final String BILL_CODE = "equipment-repair";
    @Autowired
    private IRepairService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RepairVO> saveOrUpdate(@RequestBody RepairVO saveorUpdateVO) {
        RepairEntity entity = (RepairEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), RepairEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ReportrepairEntity relist = (ReportrepairEntity)((Object)this.iReportrepairService.selectById(entity.getRecode()));
        relist.setRepairstatus(Long.valueOf("1484003619534540802"));
        this.iReportrepairService.updateById((Object)relist);
        CommonResponse<IPage<ReportrepairVO>> list = this.reportrepairController.refReportrepairData(1, 10, null, "{\"id\":\"" + entity.getRecode().toString() + "\"}", null);
        RepairVO vo = (RepairVO)((Object)BeanMapper.map((Object)((Object)entity), RepairVO.class));
        for (ReportrepairVO exlist : ((IPage)list.getData()).getRecords()) {
            vo.setEqunames(exlist.getEqunames());
            vo.setEqunum(exlist.getEqunum());
            vo.setEquspecs(exlist.getEquspecs());
            vo.setFauletypename(exlist.getFauletypename());
            vo.setCause(exlist.getCause());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RepairVO> queryDetail(Long id) {
        RepairEntity entity = (RepairEntity)((Object)this.service.selectById(id));
        CommonResponse<IPage<ReportrepairVO>> list = this.reportrepairController.refReportrepairData(1, 10, null, "{\"id\":\"" + entity.getRecode().toString() + "\"}", null);
        RepairVO vo = (RepairVO)((Object)BeanMapper.map((Object)((Object)entity), RepairVO.class));
        for (ReportrepairVO exlist : ((IPage)list.getData()).getRecords()) {
            vo.setEqunames(exlist.getEqunames());
            vo.setEqunum(exlist.getEqunum());
            vo.setEquspecs(exlist.getEquspecs());
            vo.setFauletypename(exlist.getFauletypename());
            vo.setCause(exlist.getCause());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RepairVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RepairVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RepairVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Repair-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRepairData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RepairVO>> refRepairData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RepairVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RepairVO>> list(@RequestBody String eccode) {
        System.err.println(eccode);
        QueryParam param = new QueryParam();
        param.getParams().put("recode", new Parameter("eq", (Object)eccode));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RepairVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

