/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseSettlement")
public class PurchaseSettlementBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BigDecimal sumSettlementTaxMny;
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        PurchaseSettlementEntity settlementEntity = (PurchaseSettlementEntity)((Object)this.purchaseSettlementService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal settlementMny = settlementEntity.getSettlementMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementMny();
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementTaxMny();
        BigDecimal sumOffsetMnys = settlementEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getSumOffsetMny();
        BigDecimal sumPrePayMnys = settlementEntity.getSumPrepayMny() == null ? BigDecimal.ZERO : settlementEntity.getSumPrepayMny();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(settlementEntity.getContractId()));
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementMny();
        BigDecimal bigDecimal = sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementTaxMny();
        if (offsetMny.compareTo(sumPrePayMnys.subtract(sumOffsetMnys)) > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u51b2\u62b5\u91d1\u989d\u5df2\u8d85\u51fa\u9884\u4ed8\u6b3e\u91d1\u989d!");
        }
        contractEntity.setSumOffsetMny(sumOffsetMny.add(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.add(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.add(settlementTaxMny));
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--" + contractEntity.getSumOffsetMny() + "    --" + contractEntity.getSumSettlementTaxMny());
        Boolean flag = this.purchaseContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        this.purchaseSettlementService.costPush(settlementEntity);
        if (flag.booleanValue()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseSettlementEntity settlementEntity = (PurchaseSettlementEntity)((Object)this.purchaseSettlementService.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambdachange.gt(BaseEntity::getCreateTime, (Object)settlementEntity.getCreateTime());
            lambdachange.ne(BaseEntity::getId, (Object)billId);
            int num = this.purchaseSettlementService.count((Wrapper)lambdachange);
            if (num > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u4e0d\u662f\u6700\u65b0\u7684\u7ed3\u7b97\u65e5\u671f\uff0c\u4e0d\u80fd\u56de\u9000!");
            }
            LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
            lambdachange2.eq(PurchaseSettlementEntity::getContractId, (Object)settlementEntity.getContractId());
            lambdachange2.eq(PurchaseSettlementEntity::getOrgId, (Object)settlementEntity.getOrgId());
            lambdachange2.notIn(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            int nums = this.purchaseSettlementService.count((Wrapper)lambdachange2);
            if (nums > 0) {
                return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u5408\u540c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355,\u4e0d\u5141\u8bb8\u64a4\u56de!");
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        PurchaseSettlementEntity settlementEntity = (PurchaseSettlementEntity)((Object)this.purchaseSettlementService.selectById(billId));
        BigDecimal offsetMny = settlementEntity.getOffsetMny() == null ? BigDecimal.ZERO : settlementEntity.getOffsetMny();
        BigDecimal settlementMny = settlementEntity.getSettlementMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementMny();
        BigDecimal settlementTaxMny = settlementEntity.getSettlementTaxMny() == null ? BigDecimal.ZERO : settlementEntity.getSettlementTaxMny();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(settlementEntity.getContractId()));
        BigDecimal sumOffsetMny = contractEntity.getSumOffsetMny() == null ? BigDecimal.ZERO : contractEntity.getSumOffsetMny();
        BigDecimal sumSettlementMny = contractEntity.getSumSettlementMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementMny();
        BigDecimal sumSettlementTaxMny = contractEntity.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettlementTaxMny();
        contractEntity.setSumOffsetMny(sumOffsetMny.subtract(offsetMny));
        contractEntity.setSumSettlementMny(sumSettlementMny.subtract(settlementMny));
        contractEntity.setSumSettlementTaxMny(sumSettlementTaxMny.subtract(settlementTaxMny));
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--" + contractEntity.getSumOffsetMny() + "    --" + contractEntity.getSumSettlementTaxMny());
        Boolean flag = this.purchaseContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        this.purchaseSettlementService.pullCost(billId);
        if (flag.booleanValue()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }
}

