/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"purchaseSettlement"})
public class PurchaseSettlementController {
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPayContractApi payContractApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(@RequestBody PurchaseSettlementVO purchaseSettlementVo) {
        return this.purchaseSettlementService.saveOrUpdate(purchaseSettlementVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetail(@RequestParam Long id) {
        PurchaseSettlementVO purchaseSettlementVo = this.purchaseSettlementService.queryDetail(id);
        return CommonResponse.success((Object)purchaseSettlementVo);
    }

    @RequestMapping(value={"/querySumSettlementTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> querySumSettlementTaxMny(@RequestParam Long contractId, @RequestParam Long orgId) {
        BigDecimal sumOffsetMnys;
        PurchaseSettlementVO vo = new PurchaseSettlementVO();
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(contractId, orgId);
        if (!sumPayMnyVO.isSuccess()) {
            return CommonResponse.success((String)"\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        vo.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        vo.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)contractId);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)orgId);
        lambdachange.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.purchaseSettlementService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] alreadyPurchaseMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                alreadyPurchaseMoney[0] = alreadyPurchaseMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                alreadyPurchaseMoney[1] = alreadyPurchaseMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            vo.setSumSettlementTaxMny(alreadyPurchaseMoney[0]);
            vo.setSumOffsetMny(alreadyPurchaseMoney[1]);
        }
        BigDecimal bigDecimal = sumOffsetMnys = vo.getSumOffsetMny() == null ? BigDecimal.ZERO : vo.getSumOffsetMny();
        if (vo.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            vo.setSymny(vo.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> queryDetails(@RequestParam Long id) {
        PurchaseSettlementVO purchaseSettlementVO = this.purchaseSettlementService.queryDetails(id);
        return CommonResponse.success((Object)purchaseSettlementVO);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseSettlementRecordVO> queryDetailRecord(@RequestParam Long id) {
        PurchaseSettlementRecordVO purchaseSettlementRecordVO = this.purchaseSettlementService.querySettlementRecord(id);
        return CommonResponse.success((Object)purchaseSettlementRecordVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseSettlementVO> vos) {
        this.purchaseSettlementService.deletePurchaseSettlement(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("memo");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.purchaseSettlementService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseSettlementVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("memo");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.purchaseSettlementService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseSettlementVO.class);
        }
        list.forEach(vo -> {
            vo.setPurchaseTypeName("1".equals(vo.getPurchaseType()) ? "\u81ea\u91c7" : "\u96c6\u91c7");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchaseSettlementListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/purchaseSettlementRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseSettlementVO>> purchaseSettlementRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        ComplexParam c4 = ParamUtil.getOrParam((String)"surplusApplyMny", (Parameter)new Parameter("gt", (Object)0), (Parameter)new Parameter("eq", null));
        queryParam.getComplexParams().add(c4);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("create_time", "desc");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject con = JSONObject.parseObject((String)condition);
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)con.getLong("contractId")));
            }
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)con.getLong("orgId")));
            }
            if (condition.contains("supplierId")) {
                queryParam.getParams().put("supplierId", new Parameter("eq", (Object)con.getLong("supplierId")));
            }
        }
        IPage pageData = this.purchaseSettlementService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        for (PurchaseSettlementEntity entity : pageData.getRecords()) {
            entity.setSurplusApplyMny(MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)entity.getSettlementTaxMny(), (BigDecimal)entity.getOffsetMny()), (BigDecimal)entity.getSumApplyMny()));
        }
        List purchaseSettlementVos = BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseSettlementVO.class);
        for (PurchaseSettlementVO purchaseSettlementVo : purchaseSettlementVos) {
            purchaseSettlementVo.setSettleType(Integer.valueOf(3));
        }
        result.setRecords(purchaseSettlementVos);
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> pushCost(@RequestBody PurchaseSettlementVO purchaseSettlementVO) {
        return this.purchaseSettlementService.pushCost(purchaseSettlementVO);
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="sumPayMny") BigDecimal sumPayMny, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="contractMny") BigDecimal contractMny, @RequestParam(value="projectId") Long projectId) {
        ParamsCheckVO paramsCheckVO = this.purchaseSettlementService.checkParams(purchaseType, sumPayMny, payMny, contractMny, projectId);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

