package com.ejianc.business.equipment.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.equipment.vo.RentUseRecordLeftVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 租赁设备使用记录 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@RestController
@RequestMapping("rentUseRecord")
public class RentUseRecordController {
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IOrgApi orgApi;
    /**
     * 新增或者修改
     *
     * @param rentUseRecordVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> saveOrUpdate(@RequestBody RentUseRecordVO rentUseRecordVo) {
        return rentUseRecordService.saveOrUpdate(rentUseRecordVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetail(@RequestParam Long id) {
        RentUseRecordVO rentUseRecordVo = rentUseRecordService.queryDetail(id);
        return CommonResponse.success(rentUseRecordVo);
    }


    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentUseRecordVO> vos) {
        rentUseRecordService.deleteRentUseRecord(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<RentUseRecordEntity> pageData= rentUseRecordService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * 设备使用记录参照左边列表查询
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pageListRef", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageListRef(@RequestBody RentUseRecordLeftVO rentUseRecordLeftVO) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getOrderMap().put("create_time",QueryParam.DESC);
        if(null != rentUseRecordLeftVO.getContractId()){
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, rentUseRecordLeftVO.getContractId()));
        }
        if(null != rentUseRecordLeftVO.getProjectId()){

            param.getParams().put("projectId", new Parameter(QueryParam.EQ, rentUseRecordLeftVO.getProjectId()));
        }
        if (rentUseRecordLeftVO.getSupplierId()!=null){
            param.getParams().put("supplierId", new Parameter(QueryParam.EQ, rentUseRecordLeftVO.getSupplierId()));
        }

        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getParams().put("use_flag",new Parameter("eq",0));
        if (rentUseRecordLeftVO.getSporadicUseFlag()!=null){
            param.getParams().remove("use_flag");
            param.getParams().put("sporadicUseFlag",new Parameter("eq",rentUseRecordLeftVO.getSporadicUseFlag()));
            param.getParams().put("billState", new Parameter(QueryParam.IN,
                    Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        }
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<RentUseRecordEntity> pageData= rentUseRecordService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    /**
     * 根据合同主键组装变更数据
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetails(@RequestParam Long id) {
        RentUseRecordVO rentSettlementVO = rentUseRecordService.queryDetails(id);
        return CommonResponse.success(rentSettlementVO);
    }
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("合同分页列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<RentUseRecordEntity> pageData= rentUseRecordService.queryPage(param,false);
        List<RentUseRecordVO> list = new ArrayList<>();
        if(null!=pageData.getRecords()&&CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), RentUseRecordVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("rentUseListExport.xlsx", beans, response);
    }

    /**
     * 查询合同金额使用占比
     *
     * @param rentUseRecordVo
     * @return
     */
    @RequestMapping(value = "/queryContractUseMnyRatio", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryContractUseMnyRatio(@RequestBody RentUseRecordVO rentUseRecordVo) {
        QueryWrapper<RentUseRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id",rentUseRecordVo.getContractId());
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryWrapper.select("IFNULL(SUM(use_mny),0) as lastContractUseMny");
        RentUseRecordEntity one = rentUseRecordService.getOne(queryWrapper);
        BigDecimal useMny = rentUseRecordVo.getUseMny();
        BigDecimal lastContractUseMny = ComputeUtil.safeAdd(useMny, one.getLastContractUseMny());
        BigDecimal contractUseMnyRatio = ComputeUtil.safeDiv(lastContractUseMny, rentUseRecordVo.getContractTaxMny());
        contractUseMnyRatio = ComputeUtil.safeMultiply(contractUseMnyRatio, new BigDecimal(100));
        one.setContractUseMnyRatio(contractUseMnyRatio);
        one.setLastContractUseMny(lastContractUseMny);
        RentUseRecordVO vo = BeanMapper.map(one, RentUseRecordVO.class);
        return CommonResponse.success("查询合同金额使用占比！",vo);
    }

    /**
     * 查询合同金额使用占比
     *
     * @param rentUseRecordVo
     * @return
     */
    @RequestMapping(value = "/checkContractUseMnyRatio", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkContractUseMnyRatio(@RequestBody RentUseRecordVO rentUseRecordVo) {
        ParamsCheckVO vo=rentUseRecordService.checkContractUseMnyRatio(rentUseRecordVo);
        return CommonResponse.success("查询合同金额使用占比！",vo);
    }


    /**
     * 设备使用记录参照左边列表查询
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/listRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RentUseRecordVO>> listRef() {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.getOrderMap().put("create_time",QueryParam.DESC);
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        List<RentUseRecordEntity> rentUseRecordEntityList =rentUseRecordService.queryList(param);
        List<RentUseRecordVO> list =BeanMapper.mapList(rentUseRecordEntityList,RentUseRecordVO.class);
        return CommonResponse.success("查询列表数据成功！",list);
    }


    /**
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/rentUseRecordDataRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentUseRecordVO>> rentUseRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,String searchText) {






        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getOrderMap().put("create_time", QueryParam.DESC);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject jsonObject = JSONObject.parseObject(condition);
            if (null != jsonObject.get("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, jsonObject.get("contractId")));
            }
            if (null != jsonObject.get("projectId")) {

                param.getParams().put("projectId", new Parameter(QueryParam.EQ, jsonObject.get("contractId")));
            }
            if (null != jsonObject.get("supplierId")){
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, jsonObject.get("supplierId")));
            }
            if (null != jsonObject.get("sporadicUseFlag") ){
                param.getParams().remove("use_flag");
                param.getParams().put("sporadicUseFlag",new Parameter("eq", jsonObject.get("sporadicUseFlag")));
                param.getParams().put("billState", new Parameter(QueryParam.IN,
                        Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
            }
            param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
            param.getParams().put("use_flag", new Parameter("eq", 0));
            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            IPage<RentUseRecordEntity> page = rentUseRecordService.queryPage(param,false);
            IPage<RentUseRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentUseRecordVO.class));

            return CommonResponse.success("查询参照数据成功！",pageData);
        }
        return CommonResponse.success("查询参照数据成功！",null);
    }

}
