package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同变更单审批操作业务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("purchaseChange")
public class PurchaseChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IPurchaseChangeService purchaseChangeService;

    @Autowired
    private IPurchaseContractClauseService purchaseContractClauseService;

    @Autowired
    private IPurchaseContractFeeService purchaseContractFeeService;

    @Autowired
    private IPurchaseRecordService purchaseRecordService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:"+billId+"  state:"+state);
        PurchaseChangeEntity changeEntity = purchaseChangeService.selectById(billId);
        //1，先复制合同表到合同历史表
        PurchaseContractEntity contractEntity = purchaseContractService.selectById(changeEntity.getContractId());
        PurchaseRecordEntity recordEntity = BeanMapper.map(contractEntity, PurchaseRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:"+changeEntity+"  contractEntity:"+contractEntity);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if(CollectionUtils.isNotEmpty(recordEntity.getPurchasedetail())){
            recordEntity.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getPurchasefee())){
            recordEntity.getPurchasefee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if(CollectionUtils.isNotEmpty(recordEntity.getPurchaseclause())){
            recordEntity.getPurchaseclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        purchaseRecordService.saveOrUpdate(recordEntity,false);
        LambdaUpdateWrapper<PurchaseChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PurchaseChangeEntity::getId,changeEntity.getId());
        updateWrapper.set(PurchaseChangeEntity::getChangeTime,new Date());
        purchaseChangeService.update(updateWrapper);
        logger.info("进入审批同意后回写--2");
        //2，回写合同，变更状态改为已变更，并回写字段
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setContractStatus(changeEntity.getContractStatus());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());

        contractEntity.setInvoiceType(changeEntity.getInvoiceType());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        purchaseContractClauseService.deleteByContractId(changeEntity.getContractId());
        purchaseContractFeeService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setPurchaseclause(null);
        contractEntity.setPurchasefee(null);
        if(CollectionUtils.isNotEmpty(changeEntity.getPurchasedetail())){
            logger.info("复制子表开始--"+changeEntity.getPurchasedetail());
            changeEntity.getPurchasedetail().forEach(vo -> {
                logger.info("复制子表--"+vo.getContractDetailId()+"---type"+vo.getChangeType());
                if(null!=vo.getContractDetailId()){
                    Map<Long, Integer> map = contractEntity.getPurchasedetail().stream().collect(Collectors.toMap(PurchaseContractDetailEntity::getId, PurchaseContractDetailEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setPurchasedetail(BeanMapper.mapList(changeEntity.getPurchasedetail(),PurchaseContractDetailEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getPurchasefee())){
            changeEntity.getPurchasefee().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setPurchasefee(BeanMapper.mapList(changeEntity.getPurchasefee(),PurchaseContractFeeEntity.class));
        }
        if(CollectionUtils.isNotEmpty(changeEntity.getPurchaseclause())){
            changeEntity.getPurchaseclause().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setPurchaseclause(BeanMapper.mapList(changeEntity.getPurchaseclause(),PurchaseContractClauseEntity.class));
        }
        boolean flag =  purchaseContractService.saveOrUpdate(contractEntity,false);
        logger.info("业务逻辑完成--返回"+flag);
        if(flag){
            //变更合同附件复制到主合同
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId),"BT200604000000001","102345678",String.valueOf(contractEntity.getId()),"BT200528000000001","purchaseContractBill");
            return CommonResponse.success();
        }else{
            return CommonResponse.error("审批回写异常!");
        }
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }

}
