package com.ejianc.business.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.RentChangeEntity;
import com.ejianc.business.equipment.bean.RentContractDetailEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractDetailService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.utils.ListSplitUtil;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.RentContractDetailVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 设备合同表 服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-08
 */
@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {
    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646"; // 【预算机械费总金额】控 【设备合同总金额】

    //    @Autowired
//    private IDefdocDetailService defdocDetailService;
    @Autowired
    private IRentChangeService rentChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentContractDetailService rentContractDetailService;
    @Autowired
    private RentContractMapper rentContractMapper;
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = BeanMapper.map(rentContractVo, RentContractEntity.class);
        String operateType = null;
        List<RentContractEntity> entities = null;
        List<RentChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(rentContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,rentContractVo.getId()));
            entitiesc = rentChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,rentContractVo.getBillCode()));
            entitiesc = rentChangeService.queryList(queryParam,false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBaseTaxMoney(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(rentContractVo.getContractMny()==null?BigDecimal.ZERO:rentContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(rentContractVo.getContractTaxMny()==null?BigDecimal.ZERO:rentContractVo.getContractTaxMny());
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = super.selectById(id);
        entity.setRentdetail(null);
        RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);
        List<RentContractDetailEntity> details = null;
        LambdaQueryWrapper<RentContractDetailEntity> lambda = Wrappers.<RentContractDetailEntity>lambdaQuery();
        lambda.eq(RentContractDetailEntity::getContractId,id);
        lambda.ne(RentContractDetailEntity::getChangeType,"3");
        details = rentContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            rentContractVo.setRentdetail(BeanMapper.mapList(details,RentContractDetailVO.class));
        }
        return rentContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deleteRentContract(List<RentContractVO> vos) {
        super.removeByIds(vos.stream().map(RentContractVO::getId).collect(Collectors.toList()),false);
    }
    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.querySettleWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryPayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryPrePayWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryTaxWarnContract(list));
        }
        return result;
    }
    @Override
    public List<Map<String, Object>> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(rentContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }
    @Override
    public BigDecimal totalContractMny(RentContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<RentContractEntity> rentQuery = new QueryWrapper<>();
        rentQuery.eq("project_Id", vo.getProjectId());
        rentQuery.in("change_status",Arrays.asList(1,3));
        rentQuery.in("bill_state", Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        rentQuery.eq("contract_status",2);
        if (vo.getId()!=null){
            rentQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        rentQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentContractEntity rentContract = super.getOne(rentQuery);
        if(rentContract!=null &&null != rentContract.getContractTaxMny()&&!"0".equals(rentContract.getContractTaxMny())) {
             contractTaxMny = contractTaxMny.add(rentContract.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<RentChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        RentChangeEntity changeEntity = rentChangeService.getOne(changeQuery);
        if(changeEntity!=null &&null != changeEntity.getContractTaxMny()&&!"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return  contractTaxMny;
    }


    /**
     * 参数控制
     *
     * @param vo 预算机械费总金额  设备租赁总金额
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(RentContractVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算机械费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算机械费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //预算机械费总金额
            BigDecimal budgetTaxMny =  data.getMechanicalTaxMny()==null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("【预算机械费总金额】控 【设备合同总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            //设备采购总金额
            BigDecimal  rentContractTaxMny= totalContractMny(vo);
            //设备租赁总金额
            PurchaseContractVO purchaseContract = new PurchaseContractVO();
            purchaseContract.setProjectId(vo.getProjectId());
            BigDecimal purchaseContractTaxMny = purchaseContractService.totalContractMny(purchaseContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        // 设备合同总金额 和 预算机械费总金额
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 设备合同总金额 - 预算机械费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("设备合同总金额超预算机械费总金额");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnName("设备合同总金额大于预算机械费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备合同总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，预算机械费总金额 * ")
                                    .append(roleValue).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}
