/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordLeftVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rentUseRecord"})
public class RentUseRecordController {
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> saveOrUpdate(@RequestBody RentUseRecordVO rentUseRecordVo) {
        return this.rentUseRecordService.saveOrUpdate(rentUseRecordVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetail(@RequestParam Long id) {
        RentUseRecordVO rentUseRecordVo = this.rentUseRecordService.queryDetail(id);
        return CommonResponse.success((Object)rentUseRecordVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentUseRecordVO> vos) {
        this.rentUseRecordService.deleteRentUseRecord(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/pageListRef"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageListRef(@RequestBody RentUseRecordLeftVO rentUseRecordLeftVO) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getOrderMap().put("create_time", "desc");
        if (null != rentUseRecordLeftVO.getContractId()) {
            param.getParams().put("contractId", new Parameter("eq", (Object)rentUseRecordLeftVO.getContractId()));
        }
        if (null != rentUseRecordLeftVO.getProjectId()) {
            param.getParams().put("projectId", new Parameter("eq", (Object)rentUseRecordLeftVO.getProjectId()));
        }
        if (rentUseRecordLeftVO.getSupplierId() != null) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)rentUseRecordLeftVO.getSupplierId()));
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("use_flag", new Parameter("eq", (Object)0));
        if (rentUseRecordLeftVO.getSporadicUseFlag() != null) {
            param.getParams().remove("use_flag");
            param.getParams().put("sporadicUseFlag", new Parameter("eq", (Object)rentUseRecordLeftVO.getSporadicUseFlag()));
            param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        }
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetails(@RequestParam Long id) {
        RentUseRecordVO rentSettlementVO = this.rentUseRecordService.queryDetails(id);
        return CommonResponse.success((Object)rentSettlementVO);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("rentUseListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryContractUseMnyRatio"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryContractUseMnyRatio(@RequestBody RentUseRecordVO rentUseRecordVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)rentUseRecordVo.getContractId());
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryWrapper.select(new String[]{"IFNULL(SUM(use_mny),0) as lastContractUseMny"});
        RentUseRecordEntity one = (RentUseRecordEntity)((Object)this.rentUseRecordService.getOne((Wrapper)queryWrapper));
        BigDecimal useMny = rentUseRecordVo.getUseMny();
        BigDecimal lastContractUseMny = ComputeUtil.safeAdd((BigDecimal)useMny, (BigDecimal)one.getLastContractUseMny());
        BigDecimal contractUseMnyRatio = ComputeUtil.safeDiv((BigDecimal)lastContractUseMny, (BigDecimal)rentUseRecordVo.getContractTaxMny());
        contractUseMnyRatio = ComputeUtil.safeMultiply((BigDecimal)contractUseMnyRatio, (BigDecimal)new BigDecimal(100));
        one.setContractUseMnyRatio(contractUseMnyRatio);
        one.setLastContractUseMny(lastContractUseMny);
        RentUseRecordVO vo = (RentUseRecordVO)BeanMapper.map((Object)((Object)one), RentUseRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u91d1\u989d\u4f7f\u7528\u5360\u6bd4\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkContractUseMnyRatio"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkContractUseMnyRatio(@RequestBody RentUseRecordVO rentUseRecordVo) {
        ParamsCheckVO vo = this.rentUseRecordService.checkContractUseMnyRatio(rentUseRecordVo);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u91d1\u989d\u4f7f\u7528\u5360\u6bd4\uff01", (Object)vo);
    }

    @RequestMapping(value={"/listRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentUseRecordVO>> listRef() {
        QueryParam param = new QueryParam();
        param.getOrderMap().put("create_time", "desc");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List rentUseRecordEntityList = this.rentUseRecordService.queryList(param);
        List list = BeanMapper.mapList((Iterable)rentUseRecordEntityList, RentUseRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)list);
    }

    @RequestMapping(value={"/rentUseRecordDataRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentUseRecordVO>> rentUseRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getOrderMap().put("create_time", "desc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jsonObject = JSONObject.parseObject((String)condition);
            if (null != jsonObject.get((Object)"contractId")) {
                param.getParams().put("contractId", new Parameter("eq", jsonObject.get((Object)"contractId")));
            }
            if (null != jsonObject.get((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", jsonObject.get((Object)"projectId")));
            }
            if (null != jsonObject.get((Object)"supplierId")) {
                param.getParams().put("supplierId", new Parameter("eq", jsonObject.get((Object)"supplierId")));
            }
            if (null != jsonObject.get((Object)"sporadicUseFlag")) {
                param.getParams().remove("use_flag");
                param.getParams().put("sporadicUseFlag", new Parameter("eq", jsonObject.get((Object)"sporadicUseFlag")));
                param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
            }
            param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("use_flag", new Parameter("eq", (Object)0));
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            IPage page = this.rentUseRecordService.queryPage(param, false);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentUseRecordVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", null);
    }
}

