/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentUseRecordDetailEntity;
import com.ejianc.business.equipment.bean.RentUseRecordEntity;
import com.ejianc.business.equipment.mapper.RentUseRecordMapper;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RentUseRecordService")
public class RentUseRecordServiceImpl
extends BaseServiceImpl<RentUseRecordMapper, RentUseRecordEntity>
implements IRentUseRecordService {
    private static final String RENT_USE_BILL_CODE = "EQUIPMENT_RENT_USE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_EQUIPMENT_RENT_USE_RECORD_COUNT = "P-84Y87h31";

    @Override
    public CommonResponse<RentUseRecordVO> saveOrUpdate(RentUseRecordVO rentUseRecordVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentUseRecordEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)rentUseRecordVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RENT_USE_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                rentUseRecordVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (rentUseRecordVo.getId() != null && rentUseRecordVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(RentUseRecordEntity::getBillCode, (Object)rentUseRecordVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)rentUseRecordVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(RentUseRecordEntity::getBillCode, (Object)rentUseRecordVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (RentUseRecordEntity)((Object)BeanMapper.map((Object)rentUseRecordVo, RentUseRecordEntity.class));
        entity.setDr(0);
        List<RentUseRecordDetailEntity> entityRentdetail = entity.getRentdetail();
        String equipmentName = "";
        if (entityRentdetail != null && entityRentdetail.size() > 0) {
            for (RentUseRecordDetailEntity rentUseRecordDetailEntity : entityRentdetail) {
                equipmentName = equipmentName + rentUseRecordDetailEntity.getName() + ",";
            }
            String substring = equipmentName.substring(0, equipmentName.length() - 1);
            entity.setEquipmentName(substring);
        }
        entity.setUseFlag(0);
        entity.setSporadicUseFlag(0);
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RentUseRecordVO.class));
    }

    @Override
    public RentUseRecordVO queryDetail(Long id) {
        RentUseRecordEntity entity = (RentUseRecordEntity)((Object)super.selectById((Serializable)id));
        RentUseRecordVO rentUseRecordVo = new RentUseRecordVO();
        if (entity != null) {
            rentUseRecordVo = (RentUseRecordVO)BeanMapper.map((Object)((Object)entity), RentUseRecordVO.class);
        }
        return rentUseRecordVo;
    }

    @Override
    public void deleteRentUseRecord(List<RentUseRecordVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public RentUseRecordVO queryDetails(Long id) {
        RentContractEntity entity = (RentContractEntity)((Object)this.rentContractService.selectById(id));
        RentUseRecordVO rentUseRecordVO = (RentUseRecordVO)BeanMapper.map((Object)((Object)entity), RentUseRecordVO.class);
        rentUseRecordVO.setContractId(rentUseRecordVO.getId());
        rentUseRecordVO.setId(null);
        rentUseRecordVO.setBillCode(null);
        rentUseRecordVO.setBillState(null);
        rentUseRecordVO.setCreateUserCode(null);
        rentUseRecordVO.setCreateTime(null);
        rentUseRecordVO.setUpdateUserCode(null);
        rentUseRecordVO.setUpdateTime(null);
        rentUseRecordVO.setRentdetail(null);
        rentUseRecordVO.setRentfee(null);
        return rentUseRecordVO;
    }

    @Override
    public ParamsCheckVO checkContractUseMnyRatio(RentUseRecordVO rentUseRecordVo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_EQUIPMENT_RENT_USE_RECORD_COUNT);
        if (!countParamByCode.isSuccess() || null == countParamByCode.getData()) {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        BigDecimal roleValue = ((BillParamVO)countParamByCode.getData()).getRoleValue();
        BigDecimal ratio = roleValue.divide(BigDecimal.valueOf(100L));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)rentUseRecordVo.getContractId());
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryWrapper.select(new String[]{"IFNULL(SUM(use_mny),0) as lastContractUseMny"});
        RentUseRecordEntity one = (RentUseRecordEntity)((Object)this.rentUseRecordService.getOne((Wrapper)queryWrapper));
        BigDecimal contractUseMny = ComputeUtil.safeAdd((BigDecimal)rentUseRecordVo.getUseMny(), (BigDecimal)one.getLastContractUseMny());
        BigDecimal contractUseMnyRatio = ComputeUtil.safeDiv((BigDecimal)contractUseMny, (BigDecimal)rentUseRecordVo.getContractTaxMny());
        BigDecimal contractRatiomny = ComputeUtil.safeMultiply((BigDecimal)ratio, (BigDecimal)rentUseRecordVo.getContractTaxMny());
        BigDecimal exceMny = ComputeUtil.safeSub((BigDecimal)contractUseMny, (BigDecimal)contractRatiomny);
        BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
        paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
        if (billParamVO.getControlType() == 0) {
            return paramsCheckVO;
        }
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        if (contractUseMnyRatio.compareTo(ratio) > 0) {
            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
            paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u4f7f\u7528\u8d85\u5408\u540c");
            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8bbe\u5907\u4f7f\u7528\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u672c\u6b21\u4f7f\u7528\u91d1\u989d\uff1a").append(ComputeUtil.nullToZero((BigDecimal)rentUseRecordVo.getUseMny()).setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u4f7f\u7528\u91d1\u989d\uff1a").append(contractUseMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(contractRatiomny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(exceMny.setScale(2, 4)).append("\u5143");
            paramsCheckDsVO.setContent(stringBuffer.toString());
            checkDsVOS.add(paramsCheckDsVO);
        } else {
            paramsCheckVO.setWarnType(paramsArray[0]);
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

