/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.bean.RentSettlementEntity;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentSettlementService;
import com.ejianc.business.equipment.utils.ListSplitUtil;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="PurchaseContractService")
public class PurchaseContractServiceImpl
extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity>
implements IPurchaseContractService {
    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PARAM_TOTAL_MNY = "P-oIwZ5646";
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService settlementService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private RentContractMapper rentContractMapper;

    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)purchaseContractVo, PurchaseContractEntity.class));
        Object operateType = null;
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)purchaseContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)purchaseContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)purchaseContractVo.getId()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        entity.setPurchasedetail(null);
        PurchaseContractVO purchaseContractVo = (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId, (Object)id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType, (Object)"3");
        details = this.purchaseContractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseContractVo.setPurchasedetail(BeanMapper.mapList((Iterable)details, PurchaseContractDetailVO.class));
        }
        return purchaseContractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = PurchaseContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(((PurchaseContractMapper)this.baseMapper).querySettleWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(((PurchaseContractMapper)this.baseMapper).queryPayWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(((PurchaseContractMapper)this.baseMapper).queryPrePayWarnContract(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(((PurchaseContractMapper)this.baseMapper).invoicePayMnyWarn(list));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(((PurchaseContractMapper)this.baseMapper).invoiceContractMnyWarn(list));
        }
        return result;
    }

    @Override
    public List<EquipmentWarnVo> equipmentProjectOutMny(List<Long> tenantIds) {
        return ((PurchaseContractMapper)this.baseMapper).equipmentProjectOutMny(tenantIds);
    }

    @Override
    public List<EquipmentReportVo> getMonthEquipmentMny(Long projectId, Integer lastDay) {
        return ((PurchaseContractMapper)this.baseMapper).getMonthEquipmentMny(projectId, lastDay);
    }

    @Override
    public List<EquipmentReportVo> getEquipment(Long projectId) {
        BigDecimal cgmny = BigDecimal.ZERO;
        BigDecimal cgsettleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(PurchaseContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (PurchaseContractEntity ce : quoteEntities) {
            cgmny = cgmny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            cgsettleMny = cgsettleMny.add(ce.getSettlementTaxMny() == null ? BigDecimal.ZERO : ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo = new EquipmentReportVo();
        vo.setMny(cgmny);
        vo.setNum(Integer.valueOf(quoteEntities.size()));
        vo.setSettleMny(cgsettleMny);
        BigDecimal zlmny = BigDecimal.ZERO;
        BigDecimal zlsettleMny = BigDecimal.ZERO;
        LambdaQueryWrapper lambda3 = Wrappers.lambdaQuery();
        lambda3.eq(RentContractEntity::getProjectId, (Object)projectId);
        lambda3.eq(BaseEntity::getDr, (Object)0);
        lambda3.in(RentContractEntity::getBillState, billStatus);
        List rentContractEntities = this.rentContractService.list((Wrapper)lambda3);
        for (RentContractEntity ce : rentContractEntities) {
            zlmny = zlmny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        LambdaQueryWrapper lambda4 = Wrappers.lambdaQuery();
        lambda4.eq(RentSettlementEntity::getProjectId, (Object)projectId);
        lambda4.eq(BaseEntity::getDr, (Object)0);
        lambda4.in(RentSettlementEntity::getBillState, billStatus);
        List rentSettlementEntities = this.settlementService.list((Wrapper)lambda4);
        for (RentSettlementEntity ce : rentSettlementEntities) {
            zlsettleMny = zlsettleMny.add(ce.getSettlementTaxMny() == null ? BigDecimal.ZERO : ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo2 = new EquipmentReportVo();
        vo2.setMny(zlmny);
        vo2.setNum(Integer.valueOf(rentContractEntities.size()));
        vo2.setSettleMny(zlsettleMny);
        ArrayList<EquipmentReportVo> list = new ArrayList<EquipmentReportVo>();
        list.add(vo);
        list.add(vo2);
        return list;
    }

    @Override
    public List<SettlementVO> getSettleMny(List<Long> projectIds) {
        return ((PurchaseContractMapper)this.baseMapper).getSettleMny(projectIds);
    }

    @Override
    public BigDecimal totalContractMny(PurchaseContractVO vo) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper queryPro = new QueryWrapper();
        queryPro.eq((Object)"project_Id", (Object)vo.getProjectId());
        queryPro.ne((Object)"change_status", (Object)2);
        if (vo.getId() != null) {
            queryPro.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getContractTaxMny() != null) {
            contractTaxMny = contractTaxMny.add(vo.getContractTaxMny());
        }
        queryPro.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        PurchaseContractEntity one = (PurchaseContractEntity)((Object)super.getOne((Wrapper)queryPro));
        if (one != null && null != one.getContractTaxMny() && !"0".equals(one.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(one.getContractTaxMny());
        }
        QueryWrapper changeQuery = new QueryWrapper();
        changeQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        changeQuery.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select(new String[]{"sum(contract_tax_mny) as contractTaxMny"});
        PurchaseChangeEntity changeEntity = (PurchaseChangeEntity)((Object)this.purchaseChangeService.getOne((Wrapper)changeQuery));
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseContractVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getMechanicalTaxMny() == null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            BigDecimal purchaseContractTaxMny = this.totalContractMny(vo);
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = this.rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List billParamVOS2 = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                for (BillParamVO billParamVO : billParamVOS2) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d :{},\u8bbe\u7f6e\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult), (Object)JSONObject.toJSONString((Object)totalContractMny));
                    if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8be5\u9879\u76ee\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PurchaseContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        if ((sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, InvocationInfoProxy.getOrgId())).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(null, vo.getId(), vo.getProjectId(), vo.getContractTaxMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PurchaseContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        BigDecimal sbcg = ((PurchaseContractMapper)this.baseMapper).fetchSjzcje(projectId, changeId, contractId);
        BigDecimal sbzl = this.rentContractMapper.fetchSjzcje(projectId, null, null);
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    private Integer totalMnyControl(PurchaseContractVO vo, List<ParamsCheckDsVO> checkDsVOS, Integer controlType) {
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getMechanicalTaxMny() == null ? BigDecimal.ZERO : data.getMechanicalTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            BigDecimal purchaseContractTaxMny = this.totalContractMny(vo);
            RentContractVO rentContract = new RentContractVO();
            rentContract.setProjectId(vo.getProjectId());
            BigDecimal rentContractTaxMny = this.rentContractService.totalContractMny(rentContract);
            BigDecimal totalContractMny = purchaseContractTaxMny.add(rentContractTaxMny);
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    this.logger.info("\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d :{},\u8bbe\u7f6e\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult), (Object)JSONObject.toJSONString((Object)totalContractMny));
                    if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5408\u540c\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u673a\u68b0\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                }
            }
        }
        return controlType;
    }

    @Override
    public BigDecimal fetchSjzcjePurchase(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((PurchaseContractMapper)this.baseMapper).fetchSjzcje(projectId, null, null);
    }
}

