/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementEntity;
import com.ejianc.business.equipment.bean.PurchaseSettlementFeeEntity;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.ParamsCheckDsVO;
import com.ejianc.business.equipment.vo.ParamsCheckVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="PurchaseSettlementService")
public class PurchaseSettlementServiceImpl
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";
    private static final String EQUIPMENT_PURCHASE_SETTLE = "EQUIPMENT_PURCHASE_SETTLE";
    private static final String EQUIPMENT_PURCHASE_SETTLE_DETAIL = "EQUIPMENT_PURCHASE_SETTLE_DETAIL";
    private static final String EQUIPMENT_PURCHASE_SETTLE_FEE = "EQUIPMENT_PURCHASE_SETTLE_FEE";
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayContractApi payContractApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPayContractApi paycontractapi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        BigDecimal cc;
        BigDecimal syMny;
        PurchaseSettlementEntity entity;
        Long tenantId;
        block20: {
            tenantId = InvocationInfoProxy.getTenantid();
            entity = null;
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
            lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)purchaseSettlementVo.getOrgId());
            if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
                lambdachange.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
            }
            lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdachange.ne(PurchaseSettlementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
            int num = super.count((Wrapper)lambdachange);
            if (num > 0) {
                throw new BusinessException("\u8be5\u5408\u540c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355!");
            }
            if (purchaseSettlementVo.getContractVersion() != null && purchaseSettlementVo.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(purchaseSettlementVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(purchaseSettlementVo.getContractId()));
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (version != (conVersion = purchaseSettlementVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block20;
                    }
                    CommonResponse contractEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(purchaseSettlementVo.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        LambdaQueryWrapper lambdachange2 = Wrappers.lambdaQuery();
        lambdachange2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId, (Object)purchaseSettlementVo.getContractId());
        lambdachange2.eq(PurchaseSettlementEntity::getOrgId, (Object)purchaseSettlementVo.getOrgId());
        if (null != purchaseSettlementVo.getId() && purchaseSettlementVo.getId() > 0L) {
            lambdachange2.ne(BaseEntity::getId, (Object)purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambdachange2.gt(PurchaseSettlementEntity::getSettlementDate, (Object)purchaseSettlementVo.getSettlementDate());
        int num2 = super.count((Wrapper)lambdachange2);
        if (num2 > 0) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u5bf9\u5e94\u6700\u65b0\u7ed3\u7b97\u65e5\u671f!");
        }
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getOffsetMny();
        BigDecimal bigDecimal = syMny = purchaseSettlementVo.getSymny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSymny();
        if (offsetMny.compareTo(syMny) > 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u53ef\u51b2\u62b5\u91d1\u989d!");
        }
        if (offsetMny.compareTo(settlementTaxMny) > 0 && settlementTaxMny.compareTo(BigDecimal.ZERO) >= 0) {
            throw new BusinessException("\u672c\u6b21\u51b2\u62b5\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u672c\u671f\u7ed3\u7b97\u91d1\u989d");
        }
        if (StringUtils.isEmpty((CharSequence)purchaseSettlementVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        purchaseSettlementVo.setRelationFlag("0");
        purchaseSettlementVo.setProportionFlag("0");
        entity = (PurchaseSettlementEntity)((Object)BeanMapper.map((Object)purchaseSettlementVo, PurchaseSettlementEntity.class));
        super.saveOrUpdate((Object)entity, false);
        PurchaseSettlementVO vo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return CommonResponse.success((Object)vo);
    }

    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        BigDecimal cc;
        PurchaseSettlementEntity entity = (PurchaseSettlementEntity)((Object)super.selectById((Serializable)id));
        PurchaseSettlementVO purchaseSettlementVo = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getContractTaxMny();
        BigDecimal bigDecimal = cc = purchaseSettlementVo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVo.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        BigDecimal sumPrePayMny = entity.getSumPrepayMny() == null ? BigDecimal.ZERO : entity.getSumPrepayMny();
        BigDecimal sumOffsetMny = entity.getSumOffsetMny() == null ? BigDecimal.ZERO : entity.getSumOffsetMny();
        purchaseSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return purchaseSettlementVo;
    }

    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        BigDecimal cc;
        BigDecimal sumOffsetMnys;
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        PurchaseSettlementVO purchaseSettlementVO = (PurchaseSettlementVO)BeanMapper.map((Object)((Object)entity), PurchaseSettlementVO.class);
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);
        purchaseSettlementVO.setMemo(null);
        purchaseSettlementVO.setContractVersion(entity.getVersion());
        purchaseSettlementVO.setSettlementType("0");
        CommonResponse sumPayMnyVO = this.payContractApi.getSumPayMny(id, entity.getOrgId());
        if (!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPayMny();
        BigDecimal sumPrePayMny = ((SumPayMnyVO)sumPayMnyVO.getData()).getSumPrePayMny();
        purchaseSettlementVO.setSumPayMny(sumPayMny == null ? BigDecimal.ZERO : sumPayMny);
        purchaseSettlementVO.setSumPrepayMny(sumPrePayMny == null ? BigDecimal.ZERO : sumPrePayMny);
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId, (Object)id);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4), new BigDecimal("0.00").setScale(2, 4)};
            list.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny() == null ? BigDecimal.ZERO : e.getOffsetMny());
            });
            purchaseSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            purchaseSettlementVO.setSumOffsetMny(settlementMoney[1]);
        } else {
            purchaseSettlementVO.setSumSettlementTaxMny(BigDecimal.ZERO);
            purchaseSettlementVO.setSumOffsetMny(BigDecimal.ZERO);
        }
        BigDecimal bigDecimal = sumOffsetMnys = purchaseSettlementVO.getSumOffsetMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumOffsetMny();
        if (purchaseSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO) >= 0 && sumOffsetMnys.compareTo(BigDecimal.ZERO) >= 0) {
            purchaseSettlementVO.setSymny(purchaseSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }
        BigDecimal c = purchaseSettlementVO.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getContractTaxMny();
        BigDecimal bigDecimal2 = cc = purchaseSettlementVO.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : purchaseSettlementVO.getSumSettlementTaxMny();
        if (c.compareTo(BigDecimal.ZERO) > 0 && cc.compareTo(BigDecimal.ZERO) > 0) {
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c, 8, 5)));
        }
        return purchaseSettlementVO;
    }

    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public CommonResponse<PurchaseSettlementVO> pushCost(PurchaseSettlementVO purchaseSettlementVO) {
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)((PurchaseSettlementMapper)this.baseMapper).selectById(purchaseSettlementVO.getId()));
        if (ListUtil.isNotEmpty((List)purchaseSettlementVO.getPurchasedetail())) {
            List purchaseSettleDetail = BeanMapper.mapList((Iterable)purchaseSettlementVO.getPurchasedetail(), PurchaseSettlementDetailEntity.class);
            purchaseSettlementEntity.setPurchasedetail(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty((List)purchaseSettlementVO.getPurchasefee())) {
            List purchaseSettleFee = BeanMapper.mapList((Iterable)purchaseSettlementVO.getPurchasefee(), PurchaseSettlementFeeEntity.class);
            purchaseSettlementEntity.setPurchasefee(purchaseSettleFee);
        }
        super.saveOrUpdate((Object)purchaseSettlementEntity, false);
        this.costPush(purchaseSettlementEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)purchaseSettlementEntity), PurchaseSettlementVO.class));
    }

    @Override
    public void costPush(PurchaseSettlementEntity settlementEntity) {
        this.logger.info("\u63a8\u9001\u6210\u672c\u5f00\u59cb");
        boolean newRelationFlag = true;
        List<PurchaseSettlementDetailEntity> purchasedetail = settlementEntity.getPurchasedetail();
        List<PurchaseSettlementFeeEntity> purchasefee = settlementEntity.getPurchasefee();
        for (PurchaseSettlementDetailEntity detailVO : purchasedetail) {
            if (detailVO.getSubjectId() != null && detailVO.getSubjectId() > 0L) continue;
            newRelationFlag = false;
        }
        for (PurchaseSettlementFeeEntity otherVO : purchasefee) {
            if (otherVO.getSubjectId() != null && otherVO.getSubjectId() > 0L) continue;
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settlementEntity.getId()});
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settlementEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(settlementEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0")) {
            this.saveCost(settlementEntity);
        }
        this.logger.info("\u63a8\u9001\u6210\u672c\u7ed3\u675f");
    }

    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(id));
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId, (Object)id);
        lambda.in(PurchaseSettlementEntity::getOrgId, commonOrgIds);
        lambda.in(PurchaseSettlementEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            BigDecimal sumSettlementTaxMny;
            BigDecimal[] settlementMoney = new BigDecimal[]{new BigDecimal("0.00").setScale(2, 4)};
            entities.forEach(e -> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny() == null ? BigDecimal.ZERO : e.getSettlementTaxMny());
            });
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal bigDecimal = sumSettlementTaxMny = vo.getSumSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getSumSettlementTaxMny();
            if (sumSettlementTaxMny.compareTo(BigDecimal.ZERO) != 0 && contractTaxMny.compareTo(BigDecimal.ZERO) > 0) {
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny, 8, 5)));
            } else {
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList((Iterable)entities, PurchaseSettlementVO.class));
        }
        return vo;
    }

    private void saveCost(PurchaseSettlementEntity entity) {
        List<PurchaseSettlementFeeEntity> pushPurchaseFee;
        BigDecimal rate = entity.getTaxRate() == null ? BigDecimal.ZERO : entity.getTaxRate();
        BigDecimal taxRate = rate.divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PurchaseSettlementDetailEntity> pushPurchaseDetail = entity.getPurchasedetail();
        if (ListUtil.isNotEmpty(pushPurchaseDetail)) {
            for (PurchaseSettlementDetailEntity purchaseSettlementDetailEntity : pushPurchaseDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(purchaseSettlementDetailEntity.getSubjectId());
                costDetailVO.setSourceId(purchaseSettlementDetailEntity.getSettlementId());
                costDetailVO.setSourceDetailId(purchaseSettlementDetailEntity.getId());
                costDetailVO.setHappenTaxMny(purchaseSettlementDetailEntity.getSettlementMny());
                BigDecimal pushSettlementMny = purchaseSettlementDetailEntity.getSettlementMny() == null ? BigDecimal.ZERO : purchaseSettlementDetailEntity.getSettlementMny();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_DETAIL);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
                costDetailVO.setPeriod(settlementDate.format(df));
                costDetailVO.setShareFlag(Integer.valueOf(0));
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName("\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97");
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement?id=" + entity.getId());
                costDetailVO.setNum(purchaseSettlementDetailEntity.getNum() == null ? BigDecimal.ZERO : purchaseSettlementDetailEntity.getNum());
                costDetailVO.setMaterialId(purchaseSettlementDetailEntity.getEquipmentId());
                costDetailVO.setMaterialName(purchaseSettlementDetailEntity.getName());
                costDetailVO.setUnit(purchaseSettlementDetailEntity.getUnitName());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(pushPurchaseFee = entity.getPurchasefee())) {
            for (PurchaseSettlementFeeEntity detail : pushPurchaseFee) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detail.getSubjectId());
                costDetailVO.setSourceId(detail.getSettlementId());
                costDetailVO.setSourceDetailId(detail.getId());
                costDetailVO.setHappenTaxMny(detail.getMoney());
                BigDecimal pushSettlementMny = detail.getMoney() == null ? BigDecimal.ZERO : detail.getMoney();
                BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_FEE);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
                costDetailVO.setPeriod(settlementDate.format(df));
                costDetailVO.setShareFlag(Integer.valueOf(0));
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName("\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97");
                costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement?id=" + entity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isEmpty(pushPurchaseDetail) && CollectionUtils.isEmpty(pushPurchaseFee)) {
            CostDetailVO costDetailVO = new CostDetailVO();
            costDetailVO.setSourceId(entity.getId());
            costDetailVO.setHappenTaxMny(entity.getSettlementTaxMny());
            BigDecimal pushSettlementMny = entity.getSettlementMny() == null ? BigDecimal.ZERO : entity.getSettlementMny();
            BigDecimal happenMny = pushSettlementMny.divide(number, 2, 4);
            costDetailVO.setHappenMny(happenMny);
            costDetailVO.setHappenDate(entity.getSettlementDate());
            costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
            costDetailVO.setProjectId(entity.getProjectId());
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
            LocalDate settlementDate = entity.getSettlementDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
            costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
            costDetailVO.setPeriod(settlementDate.format(df));
            costDetailVO.setShareFlag(Integer.valueOf(0));
            costDetailVO.setSourceBillCode(entity.getBillCode());
            costDetailVO.setSourceBillName("\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97");
            costDetailVO.setSourceBillUrl("/ejc-equipment-frontend/#/purchaseSettlement?id=" + entity.getId());
            costDetailVOList.add(costDetailVO);
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            CommonResponse commonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            if (commonResponse.isSuccess()) {
                this.logger.info("\u63a8\u9001\u6210\u672c\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)commonResponse));
            } else {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny, Long projectId, Long orgId) {
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        this.logger.info("sumPayMny:{},payMny:{},contractMny:{} ", new Object[]{JSONObject.toJSONString((Object)sumPayMny), JSONObject.toJSONString((Object)payMny), JSONObject.toJSONString((Object)contractMny)});
        CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (!response.isSuccess()) {
            this.logger.info(response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List billParamVOS = (List)response.getData();
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal comMny;
                if (0 == billParamVO.getControlType()) continue;
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
                if (sumPayWithThisMny.compareTo(comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100L)))) <= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(payMny.toString()).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u91d1\u989d").append(sumPayWithThisMny.toString()).append("\u5143,\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PurchaseSettlementServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

