/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.equipment.bean.PurchaseChangeEntity;
import com.ejianc.business.equipment.bean.PurchaseContractClauseEntity;
import com.ejianc.business.equipment.bean.PurchaseContractDetailEntity;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.bean.PurchaseContractFeeEntity;
import com.ejianc.business.equipment.bean.PurchaseRecordEntity;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractClauseService;
import com.ejianc.business.equipment.service.IPurchaseContractFeeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseRecordService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseChange")
public class PurchaseChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService purchaseContractService;
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IPurchaseContractClauseService purchaseContractClauseService;
    @Autowired
    private IPurchaseContractFeeService purchaseContractFeeService;
    @Autowired
    private IPurchaseRecordService purchaseRecordService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        PurchaseChangeEntity changeEntity = (PurchaseChangeEntity)((Object)this.purchaseChangeService.selectById(billId));
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.purchaseContractService.selectById(changeEntity.getContractId()));
        PurchaseRecordEntity recordEntity = (PurchaseRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), PurchaseRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        recordEntity.setContractUndiscountMny(contractEntity.getContractUndiscountMny());
        recordEntity.setDiscountMny(contractEntity.getDiscountMny());
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchasedetail())) {
            recordEntity.getPurchasedetail().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchasefee())) {
            recordEntity.getPurchasefee().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPurchaseclause())) {
            recordEntity.getPurchaseclause().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        this.purchaseRecordService.saveOrUpdate((Object)recordEntity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        updateWrapper.set(PurchaseChangeEntity::getChangeTime, (Object)new Date());
        this.purchaseChangeService.update((Wrapper)updateWrapper);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        contractEntity.setChangeStatus(3);
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setContractStatus(changeEntity.getContractStatus());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setContractUndiscountMny(changeEntity.getContractUndiscountMny());
        contractEntity.setDiscountMny(changeEntity.getDiscountMny());
        contractEntity.setInvoiceType(changeEntity.getInvoiceType());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        this.purchaseContractClauseService.deleteByContractId(changeEntity.getContractId());
        this.purchaseContractFeeService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setPurchaseclause(null);
        contractEntity.setPurchasefee(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchasedetail())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getPurchasedetail());
            changeEntity.getPurchasedetail().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getPurchasedetail().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setPurchasedetail(BeanMapper.mapList(changeEntity.getPurchasedetail(), PurchaseContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchasefee())) {
            changeEntity.getPurchasefee().forEach(vo -> vo.setId(null));
            contractEntity.setPurchasefee(BeanMapper.mapList(changeEntity.getPurchasefee(), PurchaseContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getPurchaseclause())) {
            changeEntity.getPurchaseclause().forEach(vo -> vo.setId(null));
            contractEntity.setPurchaseclause(BeanMapper.mapList(changeEntity.getPurchaseclause(), PurchaseContractClauseEntity.class));
        }
        boolean flag = this.purchaseContractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            this.attachmentApi.copyFiles(String.valueOf(billId), "BT200604000000001", "102345678", String.valueOf(contractEntity.getId()), "BT200528000000001", "purchaseContractBill", true);
            this.purchaseContractService.countContractNumAndMnyByEnquiry(contractEntity.getEnquiryPriceBillId());
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }
}

