package com.ejianc.foundation.file.api;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.hystrix.AttachmentHystrix;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.response.CommonResponse;

import feign.Response;

@FeignClient(name = "ejc-file-web", url = "${common.env.feign-client-url}", path = "ejc-file-web", fallback = AttachmentHystrix.class)
public interface IAttachmentApi {


	/**
	 * PDF转图片
	 * @param params
	 * @return
	 */
	@PostMapping(value = "/api/attachref/fileToImg")
	public CommonResponse<List<AttachmentVO>> pdfFileToImg(@RequestBody JSONObject params);

	/**
	 * @param paramStr {"sourceIds":[], "orderType":"desc"}
	 * @return
	 */
	@PostMapping(value = "/api/attachref/queryListBySourceIds")
	public CommonResponse<List<AttachmentVO>> queryAllBySourceIdList(@RequestBody JSONObject paramStr);

	@GetMapping(value = "/api/attachref/queryListBySourceId")
	public CommonResponse<List<AttachmentVO>>  queryListBySourceId(@RequestParam(name = "sourceId", required = false) Long sourceId,
																   @RequestParam(name = "billType", required = false) String billType,
																   @RequestParam(name = "sourceType", required = false) String sourceType,
																   @RequestParam(name = "orderType", required = false) String orderType);

	@PostMapping(value = "/api/attachref/updateAttachArchiveStatus")
	public CommonResponse<String> updateAttachArchiveStatus(@RequestBody String jsonParam);

	@GetMapping(value = "/api/attachref/detailById")
	public CommonResponse<AttachmentVO> queryAttachmentDetail(@RequestParam(value = "fileId") Long fileId);
	
	@PostMapping(value = "/no_auth/api/attachref/uploadFileFormNet")
	public CommonResponse<String>  uploadFileFormNet(@RequestBody UploadFileForNetParam param);

	@PostMapping(value = "/api/attachref/queryAllByIds")
	public CommonResponse<List<AttachmentVO>> queryAllByIds(@RequestBody List<Long> fileIds);

	/**
	 * 修改附件关联单据信息
	 *
	 * @param sourceId
	 *            对应的业务ID
	 * @param attachIds
	 *            附件ID
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/update", method = RequestMethod.GET)
	public CommonResponse<String> updateAttachRef(@RequestParam(name = "sourceId") Long sourceId,@RequestParam(name = "attachIds") List<Long> attachIds);

	/**
	 * 删除
	 *
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/delete", method = RequestMethod.GET)
	public CommonResponse<String> delete(@RequestParam(name="ids") String ids);
	
	/**
	 * 根据参数删除附件
	 * 
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @param fileName
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/deleteFileByParams", method = RequestMethod.GET)
	public CommonResponse<String> deleteFileByParams(@RequestParam(name = "sourceId") Long sourceId,
																   @RequestParam(name = "billType") String billType,
																   @RequestParam(name = "sourceType") String sourceType,
																   @RequestParam(name = "fileNames") List<String> fileNames);

	/**
	 * 根据参数删除附件
	 *@Author sunyj
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/deleteFileByParam", method = RequestMethod.GET)
	public CommonResponse<String> deleteFileByParam(@RequestParam(name = "sourceId") Long sourceId,
													 @RequestParam(name = "billType") String billType,
													 @RequestParam(name = "sourceType") String sourceType);


	@RequestMapping(value = "/api/attachref/copyFromSourceBillToTargetBill", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<AttachmentVO>> copyFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId,
																			 @RequestParam(name="sourceBillType") String sourceBillType,
																			 @RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
																			 @RequestParam(name="targetBillId") String targetBillId,
																			 @RequestParam(name="targetBillType") String targetBillType,
																			 @RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType);

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/9/4 将文件
	 * @Description copyFilesFromSourceBillToTargetBill
	 * @Param [
	 * sourceBillId,从此id单据复制
	 * sourceBillType 源单据类型编码
	 * sourceBillSourceType 源文件类型标识
	 * targetBillId 复制到目的单据id
	 * targetBillType 新的单据类型编码
	 * targetBillSourceType 新的文件类型标识
	 * ]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/attachref/copyFilesFromSourceBillToTargetBill", method = RequestMethod.GET)
	CommonResponse<String> copyFilesFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId,
														   @RequestParam(name="sourceBillType") String sourceBillType,
														   @RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
														   @RequestParam(name="targetBillId") String targetBillId,
														   @RequestParam(name="targetBillType") String targetBillType,
														   @RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType
	);

	/***
	 * @Author mrsir_wxp
	 * @Date 2020/9/4 将文件
	 * @Description copyFilesFromSourceBillToTargetBill
	 * @Param [
	 * sourceBillId,从此id单据复制
	 * sourceBillType 源单据类型编码
	 * sourceBillSourceType 源文件类型标识
	 * targetBillId 复制到目的单据id
	 * targetBillType 新的单据类型编码
	 * targetBillSourceType 新的文件类型标识
	 * clearTargetFile 复制前是否将目标对应类型的附件删除
	 * ]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/api/attachref/copyFiles", method = RequestMethod.GET)
	CommonResponse<List<AttachmentVO>> copyFiles(@RequestParam(name="sourceBillId") String sourceBillId,
															   @RequestParam(name="sourceBillType", required = false) String sourceBillType,
															   @RequestParam(name="sourceBillSourceType", required = false) String sourceBillSourceType,
															   @RequestParam(name="targetBillId") String targetBillId,
															   @RequestParam(name="targetBillType", required = false) String targetBillType,
															   @RequestParam(name="targetBillSourceType", required = false) String targetBillSourceType,
															   @RequestParam(name = "clearTargetFile") boolean clearTargetFile
	);

	/***
	 * @param sourceFileId  源文件id
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @param clearTargetFile
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/copyFile", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<AttachmentVO> copyFile(@RequestParam(name="sourceFileId") String sourceFileId,
												 @RequestParam(name="targetBillId") String targetBillId,
												 @RequestParam(name="targetBillType") String targetBillType,
												 @RequestParam(name="targetBillSourceType") String targetBillSourceType,
												 @RequestParam(name = "clearTargetFile") boolean clearTargetFile);

	/***
	 * 批量复制sourceFileIds文件到指定目标单据
	 *
	 * @param sourceFileIds  源文件id
	 * @param targetBillId 复制到目的单据id
	 * @param targetBillType 新的单据类型编码
	 * @param targetBillSourceType 新的文件类型标识
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/copyFileBeach", method = RequestMethod.POST)
	@ResponseBody
	CommonResponse<List<AttachmentVO>> copyFileBeach(@RequestBody List<String> sourceFileIds,
												 @RequestParam(name="targetBillId") String targetBillId,
												 @RequestParam(name="targetBillType") String targetBillType,
												 @RequestParam(name="targetBillSourceType") String targetBillSourceType);

	/**
	 * 后台根据base64上传文件
	 * @param request
	 * @return
	 */
	@PostMapping(value = "/api/attachref/uploadForBase64")
	public CommonResponse<List<AttachmentVO>> uploadForBase64(@RequestBody AttachmentRequestVO request);
	
	/**
	 * 后台根据base64上传文件(签名--支持旋转)
	 * @param request
	 * @return
	 */
	@PostMapping(value = "/api/attachref/uploadSignatureForBase64")
	public CommonResponse<List<AttachmentVO>> uploadSignatureForBase64(@RequestBody AttachmentRequestVO request);
	
	/**
	 * 获取单据附件（不鉴权）
	 * @param sourceId
	 * @param billType
	 * @param sourceType
	 * @param orderType
	 * @return
	 */
	@GetMapping(value = "/no_auth/api/attachref/queryListBySourceId")
	public CommonResponse<List<AttachmentVO>>  queryNoAuthListBySourceId(@RequestParam(name = "sourceId", required = false) Long sourceId,
																   @RequestParam(name = "billType", required = false) String billType,
																   @RequestParam(name = "sourceType", required = false) String sourceType,
																   @RequestParam(name = "orderType", required = false) String orderType);
	/**
	 * @Author mrsir_wxp
	 * @Date 2021/6/3 查询附件详情
	 * @Description queryDetail
	 * @Param [id]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.file.vo.AttachmentVO>
	 */
	@RequestMapping(value = "/api/attachref/queryDetail", method = RequestMethod.GET)
	CommonResponse<AttachmentVO> queryDetail(@RequestParam(name="id") String id);

	/**
	 * 新增附件关联信息
	 *
	 * @Author liyongjia
	 * @Description 只保存关系,不会上传附件到服务器
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/insertBatch", method = RequestMethod.POST)
	public CommonResponse<String> insertBatch(@RequestBody List<AttachmentVO> AttachmentVOs);

	/**
	 * 根据文件Id下载指定文件
	 *
	 * @param fileId
	 * @return
	 */
	@GetMapping(value = "/api/attachref/downloadFileById", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
	public Response downloadFileById(@RequestParam(value = "fileId") Long fileId);
	
	/**
	 * 添加水印
	 * 
	 * @param fileId
	 * @param watermarkText
	 *            水印内容
	 * @param waterWay
	 *            水印方式： single(单水印居中)/more(多水印)
	 * @return
	 */
	@RequestMapping(value = "/api/attachref/makeWatermarkToFile", method = RequestMethod.GET)
	public CommonResponse<String> makeWatermarkToFile(@RequestParam(value = "fileId") Long fileId,
			@RequestParam(value = "watermarkText") String watermarkText,
			@RequestParam(value = "waterWay") String waterWay);

	/**
	 * 全量更新文件信息
	 * ！！！！！注意，是全量更新，请自行查询到vo，修改相关字段后再调用该接口！！！！
	 * */
	@RequestMapping(value = "/api/attachref/updateFileInfo", method = RequestMethod.POST)
	CommonResponse<String> updateFileInfo(@RequestBody AttachmentVO vo);

	@PostMapping("/api/attachref/addMakeWatermark")
	public CommonResponse<AttachmentVO> addMakeWatermark(@RequestBody WaterMarketConfigVO waterMarketConfig);

	/**
	 * 查询文件数量
	 * */
	@GetMapping(value = "/api/attachref/queryNumberBySourceId")
	public CommonResponse<Map<Long, Integer>>  queryNumberBySourceId(@RequestParam(name = "sourceIds", required = false) List<Long> sourceIds,
																	 @RequestParam(name = "billType", required = false) String billType,
																	 @RequestParam(name = "sourceType", required = false) String sourceType);
	/**
	 * 获取文件页数
	 * */
	@GetMapping(value = "/api/attachref/queryPageNumber")
	public CommonResponse<Integer>  queryPageNumber(@RequestParam(name = "fileId", required = false) Long fileId);

}
